/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.modifier.escape;

import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogMessageModifierIF;

public class HTMLEntityEscapeSyslogMessageModifier
implements SyslogMessageModifierIF {
    private static final long serialVersionUID = -8481773209240762293L;

    public static final SyslogMessageModifierIF createDefault() {
        return new HTMLEntityEscapeSyslogMessageModifier();
    }

    @Override
    public String modify(SyslogIF syslog, int facility, int level, String message) {
        if (message != null && !"".equals(message.trim())) {
            String escapedMessage = HTMLEntityEscapeSyslogMessageModifier.escapeHtml(message);
            return escapedMessage;
        }
        return message;
    }

    @Override
    public boolean verify(String message) {
        return true;
    }

    public static String escapeHtml(String message) {
        StringBuffer b = new StringBuffer(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char ch = message.charAt(i);
            if (ch == '<') {
                b.append("&lt;");
                continue;
            }
            if (ch == '>') {
                b.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                b.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                b.append("&#39;");
                continue;
            }
            if (ch == '&') {
                b.append("&amp;");
                continue;
            }
            if (ch >= ' ' && ch <= '~') {
                b.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                b.append("&#").append((int)ch).append(";");
                continue;
            }
            if (Character.isISOControl(ch) || !Character.isDefined(ch)) continue;
            b.append("&#").append((int)ch).append(";");
        }
        return b.toString();
    }
}

