/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.backlog.printstream;

import java.io.PrintStream;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class PrintStreamSyslogBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected PrintStream printStream = null;
    protected boolean appendLinefeed = false;

    public PrintStreamSyslogBackLogHandler(PrintStream printStream) {
        this.printStream = printStream;
        this.initialize();
    }

    public PrintStreamSyslogBackLogHandler(PrintStream printStream, boolean appendLinefeed) {
        this.printStream = printStream;
        this.appendLinefeed = appendLinefeed;
        this.initialize();
    }

    public PrintStreamSyslogBackLogHandler(PrintStream printStream, boolean appendLinefeed, boolean appendReason) {
        this.printStream = printStream;
        this.appendLinefeed = appendLinefeed;
        this.appendReason = appendReason;
        this.initialize();
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
        if (this.printStream == null) {
            throw new SyslogRuntimeException("PrintStream cannot be null");
        }
    }

    @Override
    public void down(SyslogIF syslog, String reason) {
        this.printStream.println(syslog.getProtocol() + ": DOWN" + (reason != null && !"".equals(reason.trim()) ? " (" + reason + ")" : ""));
    }

    @Override
    public void up(SyslogIF syslog) {
        this.printStream.println(syslog.getProtocol() + ": UP");
    }

    @Override
    public void log(SyslogIF syslog, int level, String message, String reason) {
        String combinedMessage = this.combine(syslog, level, message, reason);
        if (this.appendLinefeed) {
            this.printStream.println(combinedMessage);
        } else {
            this.printStream.print(combinedMessage);
        }
    }
}

