/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.netmgt.icmp.jni.JniPingResponse;

public class JniPingRequestId {
    InetAddress m_addr;
    int m_identifier;
    int m_sequenceNumber;
    long m_threadId;

    public JniPingRequestId(InetAddress addr, int identifier, int sequenceNumber, long threadId) {
        this.m_addr = addr;
        this.m_identifier = identifier;
        this.m_sequenceNumber = sequenceNumber;
        this.m_threadId = threadId;
    }

    public JniPingRequestId(JniPingResponse reply) {
        this(reply.getAddress(), reply.getIdentifier(), reply.getSequenceNumber(), reply.getThreadId());
    }

    public InetAddress getAddress() {
        return this.m_addr;
    }

    public int getIdentifier() {
        return this.m_identifier;
    }

    public int getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    public long getThreadId() {
        return this.m_threadId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JniPingRequestId) {
            JniPingRequestId id = (JniPingRequestId)obj;
            return new InetAddressComparator().compare(this.getAddress(), id.getAddress()) == 0 && this.getIdentifier() == id.getIdentifier() && this.getSequenceNumber() == id.getSequenceNumber() && this.getThreadId() == id.getThreadId();
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.m_addr.hashCode();
        hash = hash * 31 + this.m_identifier;
        hash = hash * 31 + this.m_sequenceNumber;
        hash = hash * 31 + (int)(this.m_threadId >>> 32);
        hash = hash * 31 + (int)this.m_threadId;
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('[');
        buf.append("addr = ").append(this.m_addr);
        buf.append(", ");
        buf.append("ident = ").append(this.m_identifier);
        buf.append(", ");
        buf.append("seqNum = ").append(this.m_sequenceNumber);
        buf.append(", ");
        buf.append("tId = ").append(this.m_threadId);
        buf.append(']');
        return buf.toString();
    }
}

