/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.Serializable;
import java.util.Arrays;
import org.dhcp4java.Util;

public class HardwareAddress
implements Serializable {
    private final byte m_nHardwareType;
    private final byte[] m_aHardwareAddress;
    private static final byte HTYPE_ETHER = 1;

    public HardwareAddress(byte[] byArray) {
        this(1, byArray);
    }

    public HardwareAddress(byte by, byte[] byArray) {
        this.m_nHardwareType = by;
        this.m_aHardwareAddress = byArray;
    }

    public HardwareAddress(String string) {
        this(Util.hex2Bytes(string));
    }

    public HardwareAddress(byte by, String string) {
        this(by, Util.hex2Bytes(string));
    }

    public byte getHardwareType() {
        return this.m_nHardwareType;
    }

    public byte[] getHardwareAddress() {
        return (byte[])this.m_aHardwareAddress.clone();
    }

    public int hashCode() {
        return this.m_nHardwareType ^ Arrays.hashCode(this.m_aHardwareAddress);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof HardwareAddress)) {
            return false;
        }
        HardwareAddress hardwareAddress = (HardwareAddress)object;
        return this.m_nHardwareType == hardwareAddress.m_nHardwareType && Arrays.equals(this.m_aHardwareAddress, hardwareAddress.m_aHardwareAddress);
    }

    public String getHardwareAddressHex() {
        return Util.bytes2Hex(this.m_aHardwareAddress);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(28);
        if (this.m_nHardwareType != 1) {
            stringBuilder.append(this.m_nHardwareType).append("/");
        }
        for (int i = 0; i < this.m_aHardwareAddress.length; ++i) {
            if ((this.m_aHardwareAddress[i] & 0xFF) < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toString(this.m_aHardwareAddress[i] & 0xFF, 16));
            if (i >= this.m_aHardwareAddress.length - 1) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    public static HardwareAddress getHardwareAddressByString(String string) {
        if (string == null) {
            throw new NullPointerException("macStr is null");
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 6) {
            throw new IllegalArgumentException("macStr[" + string + "] has not 6 items");
        }
        byte[] byArray = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int n = Integer.parseInt(stringArray[i], 16);
            if (n < -128 || n > 255) {
                throw new IllegalArgumentException("Value is out of range:" + stringArray[i]);
            }
            byArray[i] = (byte)n;
        }
        return new HardwareAddress(byArray);
    }
}

