/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors.support;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class NtpMessage {
    public byte leapIndicator = 0;
    public byte version = (byte)3;
    public byte mode = 0;
    public short stratum = 0;
    public byte pollInterval = 0;
    public byte precision = 0;
    public double rootDelay = 0.0;
    public double rootDispersion = 0.0;
    public byte[] referenceIdentifier = new byte[]{0, 0, 0, 0};
    public double referenceTimestamp = 0.0;
    public double originateTimestamp = 0.0;
    public double receiveTimestamp = 0.0;
    public double transmitTimestamp = 0.0;

    public NtpMessage(byte[] array) {
        this.leapIndicator = (byte)(array[0] >> 6 & 3);
        this.version = (byte)(array[0] >> 3 & 7);
        this.mode = (byte)(array[0] & 7);
        this.stratum = NtpMessage.unsignedByteToShort(array[1]);
        this.pollInterval = array[2];
        this.precision = array[3];
        this.rootDelay = (double)array[4] * 256.0 + (double)NtpMessage.unsignedByteToShort(array[5]) + (double)NtpMessage.unsignedByteToShort(array[6]) / 256.0 + (double)NtpMessage.unsignedByteToShort(array[7]) / 65536.0;
        this.rootDispersion = (double)NtpMessage.unsignedByteToShort(array[8]) * 256.0 + (double)NtpMessage.unsignedByteToShort(array[9]) + (double)NtpMessage.unsignedByteToShort(array[10]) / 256.0 + (double)NtpMessage.unsignedByteToShort(array[11]) / 65536.0;
        this.referenceIdentifier[0] = array[12];
        this.referenceIdentifier[1] = array[13];
        this.referenceIdentifier[2] = array[14];
        this.referenceIdentifier[3] = array[15];
        this.referenceTimestamp = NtpMessage.decodeTimestamp(array, 16);
        this.originateTimestamp = NtpMessage.decodeTimestamp(array, 24);
        this.receiveTimestamp = NtpMessage.decodeTimestamp(array, 32);
        this.transmitTimestamp = NtpMessage.decodeTimestamp(array, 40);
    }

    public NtpMessage(byte leapIndicator, byte version, byte mode, short stratum, byte pollInterval, byte precision, double rootDelay, double rootDispersion, byte[] referenceIdentifier, double referenceTimestamp, double originateTimestamp, double receiveTimestamp, double transmitTimestamp) {
        this.leapIndicator = leapIndicator;
        this.version = version;
        this.mode = mode;
        this.stratum = stratum;
        this.pollInterval = pollInterval;
        this.precision = precision;
        this.rootDelay = rootDelay;
        this.rootDispersion = rootDispersion;
        this.referenceIdentifier = Arrays.copyOf(referenceIdentifier, referenceIdentifier.length);
        this.referenceTimestamp = referenceTimestamp;
        this.originateTimestamp = originateTimestamp;
        this.receiveTimestamp = receiveTimestamp;
        this.transmitTimestamp = transmitTimestamp;
    }

    public NtpMessage() {
        this.mode = (byte)3;
        this.transmitTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
    }

    public byte[] toByteArray() {
        byte[] p = new byte[48];
        p[0] = (byte)(this.leapIndicator << 6 | this.version << 3 | this.mode);
        p[1] = (byte)this.stratum;
        p[2] = this.pollInterval;
        p[3] = this.precision;
        int l = (int)(this.rootDelay * 65536.0);
        p[4] = (byte)(l >> 24 & 0xFF);
        p[5] = (byte)(l >> 16 & 0xFF);
        p[6] = (byte)(l >> 8 & 0xFF);
        p[7] = (byte)(l & 0xFF);
        long ul = (long)(this.rootDispersion * 65536.0);
        p[8] = (byte)(ul >> 24 & 0xFFL);
        p[9] = (byte)(ul >> 16 & 0xFFL);
        p[10] = (byte)(ul >> 8 & 0xFFL);
        p[11] = (byte)(ul & 0xFFL);
        p[12] = this.referenceIdentifier[0];
        p[13] = this.referenceIdentifier[1];
        p[14] = this.referenceIdentifier[2];
        p[15] = this.referenceIdentifier[3];
        NtpMessage.encodeTimestamp(p, 16, this.referenceTimestamp);
        NtpMessage.encodeTimestamp(p, 24, this.originateTimestamp);
        NtpMessage.encodeTimestamp(p, 32, this.receiveTimestamp);
        NtpMessage.encodeTimestamp(p, 40, this.transmitTimestamp);
        return p;
    }

    public String toString() {
        String precisionStr = new DecimalFormat("0.#E0").format(Math.pow(2.0, this.precision));
        return "Leap indicator: " + this.leapIndicator + "\nVersion: " + this.version + "\nMode: " + this.mode + "\nStratum: " + this.stratum + "\nPoll: " + this.pollInterval + "\nPrecision: " + this.precision + " (" + precisionStr + " seconds)\nRoot delay: " + new DecimalFormat("0.00").format(this.rootDelay * 1000.0) + " ms\nRoot dispersion: " + new DecimalFormat("0.00").format(this.rootDispersion * 1000.0) + " ms\nReference identifier: " + NtpMessage.referenceIdentifierToString(this.referenceIdentifier, this.stratum, this.version) + "\nReference timestamp: " + NtpMessage.timestampToString(this.referenceTimestamp) + "\nOriginate timestamp: " + NtpMessage.timestampToString(this.originateTimestamp) + "\nReceive timestamp:   " + NtpMessage.timestampToString(this.receiveTimestamp) + "\nTransmit timestamp:  " + NtpMessage.timestampToString(this.transmitTimestamp);
    }

    public static short unsignedByteToShort(byte b) {
        if ((b & 0x80) == 128) {
            return (short)(128 + (b & 0x7F));
        }
        return b;
    }

    public static double decodeTimestamp(byte[] array, int pointer) {
        double r = 0.0;
        for (int i = 0; i < 8; ++i) {
            r += (double)NtpMessage.unsignedByteToShort(array[pointer + i]) * Math.pow(2.0, (3.0 - (double)i) * 8.0);
        }
        return r;
    }

    public static void encodeTimestamp(byte[] array, int pointer, double timestamp) {
        for (int i = 0; i < 8; ++i) {
            double base = Math.pow(2.0, (3.0 - (double)i) * 8.0);
            array[pointer + i] = (byte)(timestamp / base);
            timestamp -= (double)NtpMessage.unsignedByteToShort(array[pointer + i]) * base;
        }
        array[7] = (byte)new Random().nextInt(255);
    }

    public static String timestampToString(double timestamp) {
        if (timestamp == 0.0) {
            return "0";
        }
        double utc = timestamp - 2.2089888E9;
        long ms = (long)(utc * 1000.0);
        String date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date(ms));
        double fraction = timestamp - (double)((long)timestamp);
        String fractionSting = new DecimalFormat(".000000").format(fraction);
        return date + fractionSting;
    }

    public static String referenceIdentifierToString(byte[] ref, short stratum, byte version) {
        if (stratum == 0 || stratum == 1) {
            return new String(ref);
        }
        if (version == 3) {
            return NtpMessage.unsignedByteToShort(ref[0]) + "." + NtpMessage.unsignedByteToShort(ref[1]) + "." + NtpMessage.unsignedByteToShort(ref[2]) + "." + NtpMessage.unsignedByteToShort(ref[3]);
        }
        if (version == 4) {
            return "" + ((double)NtpMessage.unsignedByteToShort(ref[0]) / 256.0 + (double)NtpMessage.unsignedByteToShort(ref[1]) / 65536.0 + (double)NtpMessage.unsignedByteToShort(ref[2]) / 1.6777216E7 + (double)NtpMessage.unsignedByteToShort(ref[3]) / 4.294967296E9);
        }
        return "";
    }
}

