/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.deviceconfig.tftp.TftpServer;
import org.opennms.features.deviceconfig.tftp.TftpStatistics;

@Command(scope="device-config", name="tftp-server-statistics", description="View or reset TFTP server statistics")
@Service
public class TftpServerStatisticsCommand
implements Action {
    @Reference
    protected TftpServer tftpServer;
    @Option(name="-a", aliases={"--action"}, description="Determines if TFTP server statistics are viewed or reset", valueToShowInHelp="view")
    private CommandAction action = CommandAction.view;

    public Object execute() {
        TftpStatistics s = this.action == CommandAction.view ? this.tftpServer.getStatistics() : this.tftpServer.getAndResetStatistics();
        System.out.println("Files received: " + s.filesReceived());
        System.out.println("Bytes received: " + s.bytesReceived());
        if (s.warnings() != 0) {
            System.out.println("\u001b[0;31mWarnings      : " + s.warnings() + "\u001b[0m");
        } else {
            System.out.println("Warnings      : " + s.warnings());
        }
        if (s.errors() != 0) {
            System.out.println("\u001b[0;31mErrors        : " + s.errors() + "\u001b[0m");
        } else {
            System.out.println("Errors        : " + s.errors());
        }
        return null;
    }

    static enum CommandAction {
        view,
        reset;

    }
}

