/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.rest.impl;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.impl.util.ConfigSwaggerConverter;
import org.opennms.features.config.exception.ConfigRuntimeException;
import org.opennms.features.config.rest.api.ConfigManagerRestService;
import org.opennms.features.config.rest.impl.JsonPathHelper;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.JsonAsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigManagerRestServiceImpl
implements ConfigManagerRestService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManagerRestServiceImpl.class);
    public static final String MESSAGE_TAG = "MESSAGE";
    @Autowired
    private ConfigurationManagerService configurationManagerService;

    public void setConfigurationManagerService(ConfigurationManagerService configurationManagerService) {
        this.configurationManagerService = configurationManagerService;
    }

    public Response getAllOpenApiSchema(String acceptType, HttpServletRequest request) {
        Map defs = this.configurationManagerService.getAllConfigDefinitions();
        Map<String, OpenAPI> apis = defs.entrySet().stream().filter(entry -> {
            OpenAPI api = ((ConfigDefinition)entry.getValue()).getSchema();
            return api != null && api.getPaths() != null;
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ConfigDefinition)e.getValue()).getSchema()));
        ConfigSwaggerConverter configSwaggerConverter = new ConfigSwaggerConverter();
        OpenAPI allAPI = configSwaggerConverter.mergeAllPathsWithRemoteRef(apis, request.getContextPath() + "/rest/cm");
        allAPI = ConfigSwaggerConverter.setupServers((OpenAPI)allAPI, Arrays.asList(request.getContextPath()));
        String outStr = configSwaggerConverter.convertOpenAPIToString(allAPI, acceptType);
        return Response.ok((Object)outStr).build();
    }

    public Response getOpenApiSchema(String configName, String acceptType, HttpServletRequest request) {
        try {
            Optional def = this.configurationManagerService.getRegisteredConfigDefinition(configName);
            if (def.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            ConfigSwaggerConverter configSwaggerConverter = new ConfigSwaggerConverter();
            OpenAPI openapi = ((ConfigDefinition)def.get()).getSchema();
            openapi = ConfigSwaggerConverter.setupServers((OpenAPI)openapi, Arrays.asList(request.getContextPath()));
            String outStr = configSwaggerConverter.convertOpenAPIToString(openapi, acceptType);
            return Response.ok((Object)outStr).build();
        }
        catch (ConfigRuntimeException e) {
            LOG.error(e.getMessage());
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response getConfigIds(String configName) {
        try {
            Set ids = this.configurationManagerService.getConfigIds(configName);
            return Response.ok((Object)ids).build();
        }
        catch (ConfigRuntimeException e) {
            LOG.error("Fail to getConfigIds for configName: {}, message: {}", (Object)configName, (Object)e.getMessage());
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response getConfig(String configName, String configId) {
        try {
            Optional json = this.configurationManagerService.getJSONStrConfiguration(configName, configId);
            if (json.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok(json.get()).build();
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response addConfig(String configName, String configId, String jsonStr) {
        try {
            this.configurationManagerService.registerConfiguration(configName, configId, new JsonAsString(jsonStr));
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response updateConfig(String configName, String configId, boolean isReplace, String jsonStr) {
        try {
            this.configurationManagerService.updateConfiguration(configName, configId, new JsonAsString(jsonStr), isReplace);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response deleteConfig(String configName, String configId) {
        try {
            this.configurationManagerService.unregisterConfiguration(configName, configId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response getConfigPart(String configName, String configId, String path) {
        try {
            Optional json = this.configurationManagerService.getJSONStrConfiguration(configName, configId);
            if (json.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)JsonPathHelper.get((String)json.get(), path)).build();
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    public Response updateConfigPart(String configName, String configId, String path, String newPartContent) {
        try {
            Optional json = this.configurationManagerService.getJSONStrConfiguration(configName, configId);
            if (json.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String newJson = JsonPathHelper.update((String)json.get(), path, newPartContent);
            this.configurationManagerService.updateConfiguration(configName, configId, new JsonAsString(newJson), true);
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return Response.ok().build();
    }

    public Response updateOrInsertConfigPart(String configName, String configId, String pathToParent, String nodeName, String newPartContent) {
        try {
            Optional json = this.configurationManagerService.getJSONStrConfiguration(configName, configId);
            if (json.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String newJson = JsonPathHelper.insertOrUpdateNode((String)json.get(), pathToParent, nodeName, newPartContent);
            this.configurationManagerService.updateConfiguration(configName, configId, new JsonAsString(newJson), true);
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return Response.ok().build();
    }

    public Response appendToArrayInConfig(String configName, String configId, String path, String newElement) {
        try {
            Optional json = this.configurationManagerService.getJSONStrConfiguration(configName, configId);
            if (json.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String newJson = JsonPathHelper.append((String)json.get(), path, newElement);
            this.configurationManagerService.updateConfiguration(configName, configId, new JsonAsString(newJson), true);
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return Response.ok().build();
    }

    public Response deleteConfigPart(String configName, String configId, String path) {
        try {
            Optional json = this.configurationManagerService.getJSONStrConfiguration(configName, configId);
            if (json.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String newJson = JsonPathHelper.delete((String)json.get(), path);
            this.configurationManagerService.updateConfiguration(configName, configId, new JsonAsString(newJson), true);
        }
        catch (Exception e) {
            LOG.error("configName: {}, configId: {}", new Object[]{configName, configId, e});
            return this.generateSimpleMessageResponse(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return Response.ok().build();
    }

    public Response listConfigs() {
        try {
            return Response.ok((Object)this.configurationManagerService.getConfigNames()).build();
        }
        catch (ConfigRuntimeException e) {
            LOG.error("listConfigs: " + e.getMessage());
            return Response.serverError().build();
        }
    }

    private Response generateSimpleMessageResponse(Response.Status status, String message) {
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put(MESSAGE_TAG, message);
        return Response.status((Response.Status)status).entity(messages).build();
    }
}

