/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wsman;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.exceptions.WSManException;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.detector.wsman.WsmanEndpointUtils;
import org.opennms.netmgt.provision.support.DetectResultsImpl;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsManWQLDetector
extends SyncAbstractDetector {
    public static final Logger LOG = LoggerFactory.getLogger(WsManWQLDetector.class);
    private static String PROTOCOL_NAME = "WSManWQL";
    private String resourceUri = "http://schemas.microsoft.com/wbem/wsman/1/wmi/root/cimv2/*";
    private String wql;
    private WSManClientFactory m_factory;

    public WsManWQLDetector() {
        super(PROTOCOL_NAME, 0);
    }

    public WsManWQLDetector(String serviceName) {
        super(serviceName, 0);
    }

    public DetectResults detect(DetectRequest request) {
        try {
            WSManEndpoint endpoint = WsmanEndpointUtils.fromMap(request.getRuntimeAttributes());
            return this.isServiceDetected(request.getAddress(), endpoint);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isServiceDetected(InetAddress address) {
        throw new UnsupportedOperationException("WSManEndpoint is required.");
    }

    public DetectResults isServiceDetected(InetAddress address, WSManEndpoint endpoint) {
        LinkedList nodes = Lists.newLinkedList();
        WSManClient client = this.m_factory.getClient(endpoint);
        try {
            LOG.debug("Issuing an ENUM on '{}' with query '{}'", (Object)this.resourceUri, (Object)this.wql);
            client.enumerateAndPullUsingFilter(this.resourceUri, "http://schemas.microsoft.com/wbem/wsman/1/WQL", this.wql, (List)nodes, true);
        }
        catch (WSManException e) {
            LOG.debug("ENUM failed for address '{}' with endpoint '{}', resourceUri '{}', query '{}'", new Object[]{address, endpoint, this.resourceUri, this.wql, e});
        }
        return new DetectResultsImpl(nodes.size() > 0);
    }

    public void setClientFactory(WSManClientFactory factory) {
        this.m_factory = factory;
    }

    public void setresourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getresourceUri() {
        return this.resourceUri;
    }

    public void setwql(String wql) {
        this.wql = wql;
    }

    public String getwql() {
        return this.wql;
    }

    protected void onInit() {
    }

    public void dispose() {
    }
}

