/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.PropertyInject;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelBeanPostProcessor {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultCamelBeanPostProcessor.class);
    protected CamelPostProcessorHelper camelPostProcessorHelper;
    protected CamelContext camelContext;

    public DefaultCamelBeanPostProcessor() {
    }

    public DefaultCamelBeanPostProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws Exception {
        LOG.trace("Camel bean processing before initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        this.injectFields(bean, beanName);
        this.injectMethods(bean, beanName);
        if (bean instanceof CamelContextAware && this.canSetCamelContext(bean, beanName)) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            DeferredContextBinding deferredBinding = bean.getClass().getAnnotation(DeferredContextBinding.class);
            CamelContext context = this.getOrLookupCamelContext();
            if (context == null && deferredBinding == null) {
                LOG.warn("No CamelContext defined yet so cannot inject into bean: {}", (Object)beanName);
            } else if (context != null) {
                contextAware.setCamelContext(context);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws Exception {
        LOG.trace("Camel bean processing after initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        if (bean instanceof DefaultEndpoint) {
            DefaultEndpoint defaultEndpoint = (DefaultEndpoint)bean;
            defaultEndpoint.setEndpointUriIfNotSpecified(beanName);
        }
        return bean;
    }

    public CamelContext getOrLookupCamelContext() {
        return this.camelContext;
    }

    public CamelPostProcessorHelper getPostProcessorHelper() {
        if (this.camelPostProcessorHelper == null) {
            this.camelPostProcessorHelper = new CamelPostProcessorHelper(this.getOrLookupCamelContext());
        }
        return this.camelPostProcessorHelper;
    }

    protected boolean canPostProcessBean(Object bean, String beanName) {
        return bean != null;
    }

    protected boolean canSetCamelContext(Object bean, String beanName) {
        CamelContextAware camelContextAware;
        CamelContext context;
        if (bean instanceof CamelContextAware && (context = (camelContextAware = (CamelContextAware)bean).getCamelContext()) != null) {
            LOG.trace("CamelContext already set on bean with id [{}]. Will keep existing CamelContext on bean.", (Object)beanName);
            return false;
        }
        return true;
    }

    protected void injectFields(final Object bean, final String beanName) {
        ReflectionHelper.doWithFields(bean.getClass(), new ReflectionHelper.FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Produce produce;
                EndpointInject endpointInject;
                BeanInject beanInject;
                PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
                if (propertyInject != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(propertyInject.context())) {
                    DefaultCamelBeanPostProcessor.this.injectFieldProperty(field, propertyInject.value(), propertyInject.defaultValue(), bean, beanName);
                }
                if ((beanInject = field.getAnnotation(BeanInject.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(beanInject.context())) {
                    DefaultCamelBeanPostProcessor.this.injectFieldBean(field, beanInject.value(), bean, beanName);
                }
                if ((endpointInject = field.getAnnotation(EndpointInject.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(endpointInject.context())) {
                    DefaultCamelBeanPostProcessor.this.injectField(field, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), bean, beanName);
                }
                if ((produce = field.getAnnotation(Produce.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(produce.context())) {
                    DefaultCamelBeanPostProcessor.this.injectField(field, produce.uri(), produce.ref(), produce.property(), bean, beanName, produce.binding());
                }
            }
        });
    }

    public void injectField(Field field, String endpointUri, String endpointRef, String endpointProperty, Object bean, String beanName) {
        this.injectField(field, endpointUri, endpointRef, endpointProperty, bean, beanName, true);
    }

    public void injectField(Field field, String endpointUri, String endpointRef, String endpointProperty, Object bean, String beanName, boolean binding) {
        ReflectionHelper.setField(field, bean, this.getPostProcessorHelper().getInjectionValue(field.getType(), endpointUri, endpointRef, endpointProperty, field.getName(), bean, beanName, binding));
    }

    public void injectFieldBean(Field field, String name, Object bean, String beanName) {
        ReflectionHelper.setField(field, bean, this.getPostProcessorHelper().getInjectionBeanValue(field.getType(), name));
    }

    public void injectFieldProperty(Field field, String propertyName, String propertyDefaultValue, Object bean, String beanName) {
        ReflectionHelper.setField(field, bean, this.getPostProcessorHelper().getInjectionPropertyValue(field.getType(), propertyName, propertyDefaultValue, field.getName(), bean, beanName));
    }

    protected void injectMethods(final Object bean, final String beanName) {
        ReflectionHelper.doWithMethods(bean.getClass(), new ReflectionHelper.MethodCallback(){

            @Override
            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                DefaultCamelBeanPostProcessor.this.setterInjection(method, bean, beanName);
                DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().consumerInjection(method, bean, beanName);
            }
        });
    }

    protected void setterInjection(Method method, Object bean, String beanName) {
        Produce produce;
        EndpointInject endpointInject;
        BeanInject beanInject;
        PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
        if (propertyInject != null && this.getPostProcessorHelper().matchContext(propertyInject.context())) {
            this.setterPropertyInjection(method, propertyInject.value(), propertyInject.defaultValue(), bean, beanName);
        }
        if ((beanInject = method.getAnnotation(BeanInject.class)) != null && this.getPostProcessorHelper().matchContext(beanInject.context())) {
            this.setterBeanInjection(method, beanInject.value(), bean, beanName);
        }
        if ((endpointInject = method.getAnnotation(EndpointInject.class)) != null && this.getPostProcessorHelper().matchContext(endpointInject.context())) {
            this.setterInjection(method, bean, beanName, endpointInject.uri(), endpointInject.ref(), endpointInject.property());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null && this.getPostProcessorHelper().matchContext(produce.context())) {
            this.setterInjection(method, bean, beanName, produce.uri(), produce.ref(), produce.property());
        }
    }

    public void setterInjection(Method method, Object bean, String beanName, String endpointUri, String endpointRef, String endpointProperty) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null) {
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method);
            } else {
                String propertyName = ObjectHelper.getPropertyName(method);
                Object value = this.getPostProcessorHelper().getInjectionValue(parameterTypes[0], endpointUri, endpointRef, endpointProperty, propertyName, bean, beanName);
                ObjectHelper.invokeMethod(method, bean, value);
            }
        }
    }

    public void setterPropertyInjection(Method method, String propertyValue, String propertyDefaultValue, Object bean, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null) {
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method);
            } else {
                String propertyName = ObjectHelper.getPropertyName(method);
                Object value = this.getPostProcessorHelper().getInjectionPropertyValue(parameterTypes[0], propertyValue, propertyDefaultValue, propertyName, bean, beanName);
                ObjectHelper.invokeMethod(method, bean, value);
            }
        }
    }

    public void setterBeanInjection(Method method, String name, Object bean, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null) {
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method);
            } else {
                Object value = this.getPostProcessorHelper().getInjectionBeanValue(parameterTypes[0], name);
                ObjectHelper.invokeMethod(method, bean, value);
            }
        }
    }
}

