/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerBuilderSupport
implements ErrorHandlerBuilder {
    private Map<RouteContext, List<OnExceptionDefinition>> onExceptions = new HashMap<RouteContext, List<OnExceptionDefinition>>();
    private ExceptionPolicyStrategy exceptionPolicyStrategy;

    @Override
    public void addErrorHandlers(RouteContext routeContext, OnExceptionDefinition exception) {
        List<OnExceptionDefinition> list = this.onExceptions.get(routeContext);
        if (list == null) {
            list = new ArrayList<OnExceptionDefinition>();
            this.onExceptions.put(routeContext, list);
        }
        if (!list.contains(exception)) {
            list.add(exception);
        }
    }

    protected void cloneBuilder(ErrorHandlerBuilderSupport other) {
        if (!this.onExceptions.isEmpty()) {
            HashMap<RouteContext, List<OnExceptionDefinition>> copy = new HashMap<RouteContext, List<OnExceptionDefinition>>(this.onExceptions);
            other.onExceptions = copy;
        }
        other.exceptionPolicyStrategy = this.exceptionPolicyStrategy;
    }

    @Override
    public void configure(RouteContext routeContext, ErrorHandler handler) {
        boolean original;
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            List<OnExceptionDefinition> list = this.onExceptions.get(routeContext);
            if (list != null) {
                for (OnExceptionDefinition exception : list) {
                    handlerSupport.addExceptionPolicy(routeContext, exception);
                }
            }
        }
        if (handler instanceof RedeliveryErrorHandler && (original = ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy())) {
            routeContext.setAllowUseOriginalMessage(true);
        }
    }

    @Override
    public List<OnExceptionDefinition> getErrorHandlers(RouteContext routeContext) {
        return this.onExceptions.get(routeContext);
    }

    @Override
    public void setErrorHandlers(RouteContext routeContext, List<OnExceptionDefinition> exceptions) {
        this.onExceptions.put(routeContext, exceptions);
    }

    public ErrorHandlerBuilderSupport exceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.setExceptionPolicyStrategy(exceptionPolicyStrategy);
        return this;
    }

    @Override
    public ExceptionPolicyStrategy getExceptionPolicyStrategy() {
        return this.exceptionPolicyStrategy;
    }

    @Override
    public void setExceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        ObjectHelper.notNull(exceptionPolicyStrategy, "ExceptionPolicyStrategy");
        this.exceptionPolicyStrategy = exceptionPolicyStrategy;
    }

    public boolean removeOnExceptionList(String id) {
        for (RouteContext routeContext : this.onExceptions.keySet()) {
            if (!this.getRouteId(routeContext).equals(id)) continue;
            this.onExceptions.remove(routeContext);
            return true;
        }
        return false;
    }

    protected String getRouteId(RouteContext routeContext) {
        CamelContext context = routeContext.getCamelContext();
        if (context != null) {
            return routeContext.getRoute().idOrCreate(context.getNodeIdFactory());
        }
        return routeContext.getRoute().getId();
    }
}

