/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import com.google.earth.kml._2.AltitudeModeType;
import com.google.earth.kml._2.PointType;
import geo.google.GeoException;
import geo.google.datamodel.GeoAltitude;
import geo.google.datamodel.GeoCoordinate;
import geo.google.mapping.Functor;
import geo.google.mapping.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PointToCoordinateFunctor
implements Functor<GeoCoordinate, PointType, GeoException> {
    private static final PointToCoordinateFunctor _instance = new PointToCoordinateFunctor();

    public static PointToCoordinateFunctor getInstance() {
        return _instance;
    }

    @Override
    public GeoCoordinate execute(PointType point) throws GeoException {
        GeoCoordinate ret = new GeoCoordinate();
        String coor = point.getCoordinates();
        double alt = -1.0;
        if (coor != null) {
            ret = MappingUtils.stringToCoordinate(coor);
        }
        AltitudeModeType mode = point.getAltitudeMode();
        GeoAltitude altitude = new GeoAltitude(alt, GeoAltitude.GeoAltitudeMode.CLAMP_TO_GROUND);
        if (mode != null) {
            switch (mode) {
                case CLAMP_TO_GROUND: {
                    altitude = new GeoAltitude(alt, GeoAltitude.GeoAltitudeMode.CLAMP_TO_GROUND);
                    break;
                }
                case RELATIVE_TO_GROUND: {
                    altitude = new GeoAltitude(alt, GeoAltitude.GeoAltitudeMode.RELATIVE_TO_GROUND);
                    break;
                }
                case ABSOLUTE: {
                    altitude = new GeoAltitude(alt, GeoAltitude.GeoAltitudeMode.ABSOLUTE);
                    break;
                }
                default: {
                    altitude = new GeoAltitude(alt, GeoAltitude.GeoAltitudeMode.CLAMP_TO_GROUND);
                }
            }
        }
        ret.setAltitude(altitude);
        return ret;
    }
}

