/*
 * Decompiled with CFR 0.152.
 */
package geo.google;

import geo.google.GeoException;
import geo.google.UserAgent;
import geo.google.datamodel.GeoAddress;
import geo.google.datamodel.GeoCoordinate;
import geo.google.datamodel.GeoUsAddress;
import geo.google.mapping.MappingUtils;
import geo.google.mapping.XmlMappingFunctor;
import geo.google.mapping.XmlToAddressFunctor;
import geo.google.mapping.XmlToUsAddressFunctor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoAddressStandardizer {
    private static final String BASE_URL = "http://maps.google.com/maps/geo?q={0}&output={1}&key={2}";
    private static final String XML = "xml";
    private static final String CSV = "csv";
    private String _apiKey;
    private long _rateLimitInterval = 5769L;
    private long _lastRequestTime = System.currentTimeMillis() - this._rateLimitInterval;
    private int _timeout = 3000;
    private static final UserAgent _userAgent = new UserAgent(){

        public String getUrlAsString(String url, int timeout) throws IOException, InterruptedException, HttpException {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
            HttpGet request = new HttpGet(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String encoding = "UTF-8";
                Header contentEncoding = entity.getContentEncoding();
                if (contentEncoding != null && contentEncoding.getValue() != null) {
                    encoding = contentEncoding.getValue();
                }
                return IOUtils.toString((InputStream)entity.getContent(), (String)encoding);
            }
            return null;
        }
    };

    public GeoAddressStandardizer(String apiKey) {
        this._apiKey = apiKey;
    }

    public GeoAddressStandardizer(String apiKey, long rateIntervalInMillis) {
        this(apiKey);
        if (rateIntervalInMillis < 0L) {
            throw new IllegalArgumentException("rateInterval cannot be negative");
        }
        this._rateLimitInterval = rateIntervalInMillis;
    }

    public GeoAddress standardizeToGeoAddress(GeoUsAddress usAddress) throws GeoException {
        return this.standardizeToGeoAddress(usAddress.toAddressLine());
    }

    public GeoUsAddress standardizeToGeoUsAddress(GeoUsAddress usAddress) throws GeoException {
        return this.standardizeToGeoUsAddress(usAddress.toAddressLine());
    }

    public GeoAddress standardizeToGeoAddress(String addressLine) throws GeoException {
        List<GeoAddress> ret = this.standardize(addressLine, XmlToAddressFunctor.getInstance());
        return CollectionUtils.isEmpty(ret) ? null : ret.get(0);
    }

    public GeoUsAddress standardizeToGeoUsAddress(String addressLine) throws GeoException {
        List<GeoUsAddress> ret = this.standardize(addressLine, XmlToUsAddressFunctor.getInstance());
        return CollectionUtils.isEmpty(ret) ? null : ret.get(0);
    }

    public List<GeoUsAddress> standardizeToGeoUsAddresses(String addressLine) throws GeoException {
        return this.standardize(addressLine, XmlToUsAddressFunctor.getInstance());
    }

    public List<GeoAddress> standardizeToGeoAddresses(String addressLine) throws GeoException {
        return this.standardize(addressLine, XmlToAddressFunctor.getInstance());
    }

    public List<GeoUsAddress> standardizeToGeoUsAddresses(GeoUsAddress usAddress) throws GeoException {
        return this.standardize(usAddress.toAddressLine(), XmlToUsAddressFunctor.getInstance());
    }

    public List<GeoAddress> standardizeToGeoAddresses(GeoUsAddress usAddress) throws GeoException {
        return this.standardize(usAddress.toAddressLine(), XmlToAddressFunctor.getInstance());
    }

    public GeoCoordinate standardizeToGeoCoordinate(String addressLine) throws GeoException {
        try {
            String url = MessageFormat.format(BASE_URL, URLEncoder.encode(addressLine, "UTF-8"), CSV, this._apiKey);
            String res = this.getServerResponse(url);
            return MappingUtils.stringToCoordinate(res);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (GeoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeoException(e);
        }
    }

    public <ReturnType> ReturnType standardize(String addressLine, XmlMappingFunctor<ReturnType> mappingFunction) throws GeoException {
        try {
            String url = MessageFormat.format(BASE_URL, URLEncoder.encode(addressLine, "UTF-8"), XML, this._apiKey);
            String res = this.getServerResponse(url);
            System.err.println("res = " + res);
            return mappingFunction.execute(res);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (GeoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeoException(e);
        }
    }

    private synchronized String getServerResponse(String url) throws Exception {
        long timeTilNextStart = this._rateLimitInterval - (System.currentTimeMillis() - this._lastRequestTime);
        if (timeTilNextStart > 0L) {
            Thread.sleep(timeTilNextStart);
        }
        this._lastRequestTime = System.currentTimeMillis();
        return _userAgent.getUrlAsString(url, this._timeout);
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public void setApiKey(String apiKey) {
        this._apiKey = apiKey;
    }

    public long getRateLimitInterval() {
        return this._rateLimitInterval;
    }

    public void setRateLimitInterval(long rateLimitInterval) {
        this._rateLimitInterval = rateLimitInterval;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }
}

