/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.util.ilr;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.util.ilr.Arguments;
import org.opennms.util.ilr.Option;

public class ArgumentParser {
    private String m_programName;
    private Object m_argHandler;
    private Method m_argMethod;
    private String m_argHelp;
    PrintStream out = System.err;
    private Map<Option, Method> m_options = new LinkedHashMap<Option, Method>();

    public ArgumentParser(String programName, Object argHandler) {
        Method[] methods;
        this.m_programName = programName;
        this.m_argHandler = argHandler;
        for (Method m : methods = this.m_argHandler.getClass().getMethods()) {
            if (m.isAnnotationPresent(Option.class)) {
                Option option = m.getAnnotation(Option.class);
                this.m_options.put(option, m);
            }
            if (!m.isAnnotationPresent(Arguments.class)) continue;
            this.m_argMethod = m;
            this.m_argHelp = m.getAnnotation(Arguments.class).help();
        }
    }

    public void processArgs(String[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < args.length; ++i) {
            Option o;
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                this.printHelpOptions();
                continue;
            }
            if (arg.startsWith("--")) {
                o = this.findOptionByLongName(arg.substring(2));
                this.executeOption(o, arg);
                continue;
            }
            if (arg.startsWith("-")) {
                o = this.findOptionByShortName(arg.substring(1));
                this.executeOption(o, arg);
                continue;
            }
            this.m_argMethod.invoke(this.m_argHandler, arg);
        }
    }

    public void printHelpOptions() {
        this.out.printf("Usage: %s <options> <arguments> %n", this.m_programName);
        this.out.printf("   where <arguments> is %s%n", this.m_argHelp);
        this.out.printf("Options: %n", new Object[0]);
        this.out.printf("   -%-5s or --%-15s : %s%n", "h", "help", "print this help");
        for (Option o : this.m_options.keySet()) {
            this.out.printf("   -%-5s or --%-15s : %s%n", o.shortName(), o.longName(), o.help());
        }
    }

    public void executeOption(Option o, String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (o == null) {
            throw new IllegalArgumentException("Illegal Argument: " + arg);
        }
        Method m = this.m_options.get(o);
        m.invoke(this.m_argHandler, new Object[0]);
    }

    public Option findOptionByShortName(String arg) {
        for (Option o : this.m_options.keySet()) {
            if (!arg.equals(o.shortName())) continue;
            return o;
        }
        return null;
    }

    public Option findOptionByLongName(String arg) {
        for (Option o : this.m_options.keySet()) {
            if (!arg.equals(o.longName())) continue;
            return o;
        }
        return null;
    }
}

