/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.api;

import java.util.ServiceLoader;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategyProvider;
import org.opennms.netmgt.measurements.impl.NullFetchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

public class MeasurementFetchStrategyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementFetchStrategyFactory.class);
    private static ServiceLoader<MeasurementFetchStrategyProvider> providerLoader = ServiceLoader.load(MeasurementFetchStrategyProvider.class);

    @Bean(name={"measurementFetchStrategy"})
    public MeasurementFetchStrategy getStrategy() throws InstantiationException, IllegalAccessException {
        String timeSeriesStrategyName = System.getProperty("org.opennms.timeseries.strategy", "rrd");
        String rrdStrategyClass = System.getProperty("org.opennms.rrd.strategyClass", "org.opennms.netmgt.rrd.rrdtool.MultithreadedJniRrdStrategy");
        for (MeasurementFetchStrategyProvider provider : providerLoader) {
            Class<? extends MeasurementFetchStrategy> strategy = provider.getStrategyClass(timeSeriesStrategyName, rrdStrategyClass);
            if (strategy == null) continue;
            return strategy.newInstance();
        }
        LOG.error("No supported fetch strategy found for {}/{}. Defaulting to NullFetchStrategy.", (Object)timeSeriesStrategyName, (Object)rrdStrategyClass);
        return new NullFetchStrategy();
    }
}

