/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.IdentifiableEntity;
import com.atlassian.jira.rest.client.api.NamedEntity;
import com.atlassian.jira.rest.client.api.domain.FieldSchema;
import com.atlassian.jira.rest.client.api.domain.FieldType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;

public class Field
implements NamedEntity,
IdentifiableEntity<String> {
    private final String id;
    private final String name;
    private final FieldType fieldType;
    private final boolean orderable;
    private final boolean navigable;
    private final boolean searchable;
    @Nullable
    private final FieldSchema schema;

    public Field(String id, String name, FieldType fieldType, boolean orderable, boolean navigable, boolean searchable, @Nullable FieldSchema schema) {
        this.id = id;
        this.name = name;
        this.fieldType = fieldType;
        this.orderable = orderable;
        this.navigable = navigable;
        this.searchable = searchable;
        this.schema = schema;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public boolean isNavigable() {
        return this.navigable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    @Nullable
    public FieldSchema getSchema() {
        return this.schema;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.name, this.fieldType, this.orderable, this.navigable, this.searchable, this.schema});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Field) {
            Field that = (Field)obj;
            return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal((Object)this.fieldType, (Object)that.fieldType) && Objects.equal(this.orderable, that.orderable) && Objects.equal(this.navigable, that.navigable) && Objects.equal(this.searchable, that.searchable) && Objects.equal(this.schema, that.schema);
        }
        return false;
    }

    protected MoreObjects.ToStringHelper getToStringHelper() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("fieldType", (Object)this.fieldType).add("orderable", this.orderable).add("navigable", this.navigable).add("searchable", this.searchable).add("schema", this.schema);
    }

    public String toString() {
        return this.getToStringHelper().toString();
    }
}

