/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.extremecomponents.table.callback.FilterPredicate;
import org.extremecomponents.table.callback.FilterRowsCallback;
import org.extremecomponents.table.callback.SortRowsCallback;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.limit.Sort;
import org.extremecomponents.tree.TreeModelUtils;
import org.extremecomponents.tree.TreeNode;

public final class ProcessTreeRowsCallback
implements FilterRowsCallback,
SortRowsCallback {
    public Collection filterRows(TableModel model, Collection rows) throws Exception {
        model.getTableHandler().getTable().addAttribute("openNodes", this.getParameters(model.getRegistry().getParameterMap(), "o_", model.getTableHandler().prefixWithTableId()));
        boolean filtered = model.getLimit().isFiltered();
        boolean cleared = model.getLimit().isCleared();
        if (filtered && !cleared) {
            rows = this.filter(model, rows);
            rows = TreeModelUtils.findParents(model, rows);
            rows = TreeModelUtils.loadTreeStructure(model, rows);
            TreeModelUtils.addClosedChildren(model, rows);
        } else {
            rows = TreeModelUtils.loadTreeStructure(model, rows);
        }
        this.setFilteredCount(model, rows);
        return rows;
    }

    private Map getParameters(Map parameterMap, String parameter, String prefixWithTableId) {
        HashMap<String, String[]> subset = new HashMap<String, String[]>();
        String find = prefixWithTableId + parameter;
        Set set = parameterMap.keySet();
        for (String name : set) {
            if (!name.startsWith(find)) continue;
            String[] values = (String[])parameterMap.get(name);
            subset.put(name, values);
        }
        return subset;
    }

    private Collection filter(TableModel model, Collection rows) throws Exception {
        ArrayList results = new ArrayList();
        FilterPredicate filterPredicate = new FilterPredicate(model);
        CollectionUtils.select((Iterable)rows, (Predicate)filterPredicate, results);
        for (int i = 0; i < results.size(); ++i) {
            Object bean = results.get(i);
            TreeModelUtils.findBeanParents(model, rows, results, bean);
        }
        return results;
    }

    private void setFilteredCount(TableModel model, Collection rows) {
        if (rows == null) {
            model.getTableHandler().getTable().addAttribute("FILTERED_COUNT", "0");
            return;
        }
        model.getTableHandler().getTable().addAttribute("FILTERED_COUNT", rows.size() + "");
    }

    @Override
    public Collection sortRows(TableModel model, Collection rows) throws Exception {
        boolean sorted = model.getLimit().isSorted();
        if (!sorted) {
            return rows;
        }
        ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
        for (TreeNode node : rows) {
            if (node.getParent() != null) continue;
            parents.add(node);
        }
        ArrayList output = new ArrayList();
        Sort sort = model.getLimit().getSort();
        String property = sort.getProperty();
        String sortOrder = sort.getSortOrder();
        this.subSort(parents, property, sortOrder);
        this.recursiveSort(output, parents, property, sortOrder);
        output.retainAll(rows);
        rows.clear();
        rows.addAll(output);
        return rows;
    }

    private void recursiveSort(List output, List rows, String property, String sortOrder) {
        for (TreeNode node : rows) {
            output.add(node);
            if (node.getChildren() == null || node.getChildren().size() <= 0) continue;
            this.subSort(node.getChildren(), property, sortOrder);
            this.recursiveSort(output, node.getChildren(), property, sortOrder);
        }
    }

    private void subSort(List rows, String property, String sortOrder) {
        if (sortOrder.equals("asc")) {
            BeanComparator comparator = new BeanComparator(property, (Comparator)new NullComparator());
            Collections.sort(rows, comparator);
        } else if (sortOrder.equals("desc")) {
            BeanComparator reversedNaturalOrderBeanComparator = new BeanComparator(property, (Comparator)new ReverseComparator((Comparator)new NullComparator()));
            Collections.sort(rows, reversedNaturalOrderBeanComparator);
        }
    }
}

