/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view;

import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.View;
import org.extremecomponents.table.view.html.CalcBuilder;
import org.extremecomponents.table.view.html.FormBuilder;
import org.extremecomponents.table.view.html.RowBuilder;
import org.extremecomponents.table.view.html.TableBuilder;
import org.extremecomponents.util.HtmlBuilder;

public abstract class AbstractHtmlView
implements View {
    private HtmlBuilder html;
    private TableModel model;
    private FormBuilder formBuilder;
    private boolean bufferView;
    private TableBuilder tableBuilder;
    private RowBuilder rowBuilder;
    private CalcBuilder calcBuilder;

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    protected void setTableBuilder(TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public RowBuilder getRowBuilder() {
        return this.rowBuilder;
    }

    protected void setRowBuilder(RowBuilder rowBuilder) {
        this.rowBuilder = rowBuilder;
    }

    public CalcBuilder getCalcBuilder() {
        return this.calcBuilder;
    }

    protected void setCalcBuilder(CalcBuilder calcBuilder) {
        this.calcBuilder = calcBuilder;
    }

    @Override
    public final void beforeBody(TableModel model) {
        this.model = model;
        this.bufferView = model.getTableHandler().getTable().isBufferView();
        this.html = this.bufferView ? new HtmlBuilder() : new HtmlBuilder(model.getContext().getWriter());
        this.formBuilder = new FormBuilder(this.html, model);
        this.init(this.html, model);
        this.formBuilder.formStart();
        this.tableBuilder.themeStart();
        this.beforeBodyInternal(model);
    }

    @Override
    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.rowBuilder.rowStart();
        }
        this.html.append(column.getCellDisplay());
        if (column.isLastColumn()) {
            this.rowBuilder.rowEnd();
        }
    }

    @Override
    public final Object afterBody(TableModel model) {
        this.afterBodyInternal(model);
        this.tableBuilder.themeEnd();
        this.formBuilder.formEnd();
        if (this.bufferView) {
            return this.html.toString();
        }
        return "";
    }

    protected void init(HtmlBuilder html, TableModel model) {
        this.setTableBuilder(new TableBuilder(html, model));
        this.setRowBuilder(new RowBuilder(html, model));
        this.setCalcBuilder(new CalcBuilder(html, model));
    }

    protected abstract void beforeBodyInternal(TableModel var1);

    protected abstract void afterBodyInternal(TableModel var1);
}

