/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.calc;

import java.math.BigDecimal;
import java.util.Collection;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.calc.Calc;
import org.extremecomponents.table.calc.CalcHandler;
import org.extremecomponents.table.calc.CalcUtils;
import org.extremecomponents.table.core.TableModel;

public class AverageCalc
implements Calc {
    @Override
    public Number getCalcResult(TableModel model, Column column) {
        Collection rows = model.getCollectionOfFilteredBeans();
        String property = column.getProperty();
        AverageValue totalValue = new AverageValue(rows.size());
        CalcUtils.eachRowCalcValue(totalValue, rows, property);
        return totalValue.getAverageValue();
    }

    private static class AverageValue
    implements CalcHandler {
        private double total = 0.0;
        private double rowCount;

        public AverageValue(double rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public void processCalcValue(Number calcValue) {
            this.total += calcValue.doubleValue();
        }

        public Number getAverageValue() {
            if (this.rowCount > 0.0) {
                return BigDecimal.valueOf(this.total / this.rowCount);
            }
            return BigDecimal.valueOf(0.0);
        }
    }
}

