/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.nxos.adapter;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.nxos.adapter.proto.TelemetryBis;

public class NxosGpbParserUtil {
    public static Double getValueAsDouble(TelemetryBis.Telemetry msg, String name) {
        if (Objects.isNull(msg) || Objects.isNull(name)) {
            return Double.NaN;
        }
        for (TelemetryBis.TelemetryField field : msg.getDataGpbkvList()) {
            TelemetryBis.TelemetryField subField = NxosGpbParserUtil.findFieldWithName(field, name);
            if (subField == null) continue;
            return NxosGpbParserUtil.getDoubleValue(subField);
        }
        return Double.NaN;
    }

    public static String getValueAsString(TelemetryBis.Telemetry msg, String name) {
        if (Objects.isNull(msg) || Objects.isNull(name)) {
            return null;
        }
        for (TelemetryBis.TelemetryField field : msg.getDataGpbkvList()) {
            TelemetryBis.TelemetryField subField = NxosGpbParserUtil.findFieldWithName(field, name);
            if (subField == null) continue;
            return NxosGpbParserUtil.getStringValue(subField);
        }
        return null;
    }

    public static List<TelemetryBis.TelemetryField> getRowsFromTable(TelemetryBis.Telemetry msg, String name) {
        if (Objects.isNull(msg) || Objects.isNull(name)) {
            return Collections.emptyList();
        }
        for (TelemetryBis.TelemetryField field : msg.getDataGpbkvList()) {
            TelemetryBis.TelemetryField subField = NxosGpbParserUtil.findFieldWithName(field, "ROW_" + name);
            if (subField == null) continue;
            return subField.getFieldsList();
        }
        return Collections.emptyList();
    }

    public static String getValueFromRowAsString(TelemetryBis.TelemetryField row, String name) {
        if (Objects.isNull(row) || Objects.isNull(name)) {
            return null;
        }
        for (TelemetryBis.TelemetryField nestedField : row.getFieldsList()) {
            TelemetryBis.TelemetryField subField = NxosGpbParserUtil.findFieldWithName(nestedField, name);
            if (subField == null) continue;
            return NxosGpbParserUtil.getStringValue(subField);
        }
        return null;
    }

    public static Double getValueFromRowAsDouble(TelemetryBis.TelemetryField row, String name) {
        if (Objects.isNull(row) || Objects.isNull(name)) {
            return Double.NaN;
        }
        for (TelemetryBis.TelemetryField field : row.getFieldsList()) {
            TelemetryBis.TelemetryField subField = NxosGpbParserUtil.findFieldWithName(field, name);
            if (subField == null) continue;
            return NxosGpbParserUtil.getDoubleValue(subField);
        }
        return Double.NaN;
    }

    public static Double getValueAsDoubleRelativeToField(TelemetryBis.Telemetry msg, String parentFieldName, String name) {
        if (Objects.isNull(msg) || Objects.isNull(parentFieldName) || Objects.isNull(name)) {
            return Double.NaN;
        }
        for (TelemetryBis.TelemetryField field : msg.getDataGpbkvList()) {
            TelemetryBis.TelemetryField subField;
            TelemetryBis.TelemetryField parentField = NxosGpbParserUtil.findFieldWithName(field, parentFieldName);
            if (parentField == null || (subField = NxosGpbParserUtil.findFieldWithName(parentField, name)) == null) continue;
            return NxosGpbParserUtil.getDoubleValue(subField);
        }
        return Double.NaN;
    }

    public static String getValueAsStringRelativeToField(TelemetryBis.Telemetry msg, String parentFieldName, String name) {
        if (Objects.isNull(msg) || Objects.isNull(parentFieldName) || Objects.isNull(name)) {
            return null;
        }
        for (TelemetryBis.TelemetryField field : msg.getDataGpbkvList()) {
            TelemetryBis.TelemetryField subField;
            TelemetryBis.TelemetryField parentField = NxosGpbParserUtil.findFieldWithName(field, parentFieldName);
            if (parentField == null || (subField = NxosGpbParserUtil.findFieldWithName(parentField, name)) == null) continue;
            return NxosGpbParserUtil.getStringValue(subField);
        }
        return null;
    }

    private static TelemetryBis.TelemetryField findFieldWithName(TelemetryBis.TelemetryField field, String name) {
        if (Objects.equals(field.getName(), name)) {
            return field;
        }
        for (TelemetryBis.TelemetryField subField : field.getFieldsList()) {
            TelemetryBis.TelemetryField matchingField = NxosGpbParserUtil.findFieldWithName(subField, name);
            if (matchingField == null) continue;
            return matchingField;
        }
        return null;
    }

    private static Double getDoubleValue(TelemetryBis.TelemetryField field) {
        TelemetryBis.TelemetryField.ValueByTypeCase typeOfValue = field.getValueByTypeCase();
        if (TelemetryBis.TelemetryField.ValueByTypeCase.STRING_VALUE.equals((Object)typeOfValue)) {
            return Double.parseDouble(field.getStringValue());
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.UINT64_VALUE.equals((Object)typeOfValue)) {
            return field.getUint64Value();
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.UINT32_VALUE.equals((Object)typeOfValue)) {
            return field.getUint32Value();
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.DOUBLE_VALUE.equals((Object)typeOfValue)) {
            return field.getDoubleValue();
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.FLOAT_VALUE.equals((Object)typeOfValue)) {
            return field.getFloatValue();
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.SINT32_VALUE.equals((Object)typeOfValue)) {
            return field.getSint32Value();
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.SINT64_VALUE.equals((Object)typeOfValue)) {
            return field.getSint64Value();
        }
        return Double.NaN;
    }

    private static String getStringValue(TelemetryBis.TelemetryField field) {
        TelemetryBis.TelemetryField.ValueByTypeCase typeOfValue = field.getValueByTypeCase();
        if (TelemetryBis.TelemetryField.ValueByTypeCase.STRING_VALUE.equals((Object)typeOfValue)) {
            return field.getStringValue();
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.UINT64_VALUE.equals((Object)typeOfValue)) {
            return String.valueOf(field.getUint64Value());
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.UINT32_VALUE.equals((Object)typeOfValue)) {
            return String.valueOf(field.getUint32Value());
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.DOUBLE_VALUE.equals((Object)typeOfValue)) {
            return String.valueOf(field.getDoubleValue());
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.FLOAT_VALUE.equals((Object)typeOfValue)) {
            return String.valueOf(field.getFloatValue());
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.SINT32_VALUE.equals((Object)typeOfValue)) {
            return String.valueOf(field.getSint32Value());
        }
        if (TelemetryBis.TelemetryField.ValueByTypeCase.SINT64_VALUE.equals((Object)typeOfValue)) {
            return String.valueOf(field.getSint64Value());
        }
        return null;
    }
}

