/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.dao.util.ReductionKeyHelper;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class IpServiceImpl
implements IpService {
    private final BusinessServiceManager m_manager;
    private final OnmsMonitoredService m_entity;

    public IpServiceImpl(BusinessServiceManager manager, OnmsMonitoredService entity) {
        this.m_manager = manager;
        this.m_entity = entity;
    }

    public OnmsMonitoredService getEntity() {
        return this.m_entity;
    }

    public int getId() {
        return this.m_entity.getId();
    }

    public String getServiceName() {
        return this.m_entity.getServiceName();
    }

    public String getNodeLabel() {
        if (this.m_entity.getNodeId() != null) {
            return this.m_manager.getNodeById(this.m_entity.getNodeId()).getLabel();
        }
        return null;
    }

    public Integer getNodeId() {
        if (this.m_entity.getNodeId() != null) {
            return this.m_manager.getNodeById(this.m_entity.getNodeId()).getId();
        }
        return null;
    }

    public String getIpAddress() {
        return this.m_entity.getIpAddress().toString();
    }

    public Set<String> getReductionKeys() {
        return Collections.unmodifiableSet(ReductionKeyHelper.getReductionKeys((OnmsMonitoredService)this.m_entity));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpServiceImpl other = (IpServiceImpl)obj;
        return Objects.equals(this.getEntity(), other.getEntity());
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("serviceName", (Object)this.getServiceName()).add("nodeLabel", (Object)this.getNodeLabel()).add("ipAddress", (Object)this.getIpAddress()).add("reductionKeys", this.getReductionKeys()).toString();
    }
}

