/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class TicketNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TicketNotificationStrategy.class);
    private EventIpcManager m_eventManager = EventIpcManagerFactory.getIpcManager();
    private DefaultEventConfDao m_eventConfDao;

    public int send(List<Argument> arguments) {
        String eventID = null;
        String eventUEI = null;
        String noticeID = null;
        for (Argument arg : arguments) {
            LOG.debug("arguments: {} = {}", (Object)arg.getSwitch(), (Object)arg.getValue());
            if ("eventID".equalsIgnoreCase(arg.getSwitch())) {
                eventID = arg.getValue();
                continue;
            }
            if ("eventUEI".equalsIgnoreCase(arg.getSwitch())) {
                eventUEI = arg.getValue();
                continue;
            }
            if (!"noticeid".equalsIgnoreCase(arg.getSwitch())) continue;
            noticeID = arg.getValue();
        }
        if (StringUtils.isBlank(eventID)) {
            LOG.error("There is no event-id associated with the notice-id='{}'. Cannot create ticket.", noticeID);
            return 1;
        }
        if (StringUtils.isBlank(eventUEI)) {
            LOG.error("There is no event-uei associated with the notice-id='{}'. Cannot create ticket.", noticeID);
            return 1;
        }
        AlarmType alarmType = this.getAlarmTypeFromUEI(eventUEI);
        if (alarmType == AlarmType.NOT_AN_ALARM) {
            LOG.warn("The event type associated with the notice-id='{}' is not an alarm. Will not create ticket.", noticeID);
            return 0;
        }
        AlarmState alarmState = this.getAlarmStateFromEvent(Integer.parseInt(eventID));
        if (alarmState.getAlarmID() == 0) {
            LOG.error("There is no alarm-id associated with the event-id='{}'. Will not create ticket.", (Object)eventID);
            return 1;
        }
        LOG.info("Got event-uei='{}' with event-id='{}', notice-id='{}', alarm-type='{}', alarm-id='{}', tticket-id='{}'and tticket-state='{}'", new Object[]{eventUEI, eventID, noticeID, alarmType, alarmState.getAlarmID(), alarmState.getTticketID(), alarmState.getTticketState()});
        this.sendCreateTicketEvent(alarmState.getAlarmID(), eventUEI);
        return 0;
    }

    protected AlarmState getAlarmStateFromEvent(int eventID) {
        AlarmStateRowCallbackHandler callbackHandler = new AlarmStateRowCallbackHandler();
        JdbcTemplate template = new JdbcTemplate(DataSourceFactory.getInstance());
        template.query("SELECT a.alarmid, a.tticketid, a.tticketstate FROM events AS e LEFT JOIN alarms AS a ON a.alarmid = e.alarmid WHERE e.eventid = ?", new Object[]{eventID}, (RowCallbackHandler)callbackHandler);
        return callbackHandler.getAlarmState();
    }

    protected AlarmType getAlarmTypeFromUEI(String eventUEI) {
        Event event = this.m_eventConfDao.findByUei(eventUEI);
        if (event == null) {
            return AlarmType.NOT_AN_ALARM;
        }
        if (event.getAlarmData() != null && event.getAlarmData().getAlarmType() != null) {
            if (event.getAlarmData().getAlarmType() == 2) {
                return AlarmType.RESULTION;
            }
            return AlarmType.PROBLEM;
        }
        return AlarmType.NOT_AN_ALARM;
    }

    public void sendCreateTicketEvent(int alarmID, String alarmUEI) {
        LOG.debug("Sending create ticket for alarm '{}' with id={}", (Object)alarmUEI, (Object)alarmID);
        EventBuilder ebldr = new EventBuilder("uei.opennms.org/troubleTicket/create", this.getName());
        ebldr.addParam("alarmId", alarmID);
        ebldr.addParam("alarmUei", alarmUEI);
        ebldr.addParam("user", "admin");
        this.m_eventManager.sendNow(ebldr.getEvent());
    }

    public String getName() {
        return "Notifd:TicketNotificationStrategy";
    }

    static enum AlarmType {
        NOT_AN_ALARM,
        PROBLEM,
        RESULTION;

    }

    public static class AlarmState {
        int m_alarmID;
        String m_tticketID;
        int m_tticketState;

        AlarmState(int alarmID) {
            this.m_alarmID = alarmID;
            this.m_tticketID = "";
            this.m_tticketState = 0;
        }

        AlarmState(int alarmID, String tticketID, int tticketState) {
            this.m_alarmID = alarmID;
            this.m_tticketID = tticketID;
            this.m_tticketState = tticketState;
        }

        public int getAlarmID() {
            return this.m_alarmID;
        }

        public String getTticketID() {
            return this.m_tticketID;
        }

        public int getTticketState() {
            return this.m_tticketState;
        }
    }

    protected static class AlarmStateRowCallbackHandler
    implements RowCallbackHandler {
        AlarmState m_alarmState = null;

        public void processRow(ResultSet rs) throws SQLException {
            this.m_alarmState = new AlarmState(rs.getInt(1), rs.getString(2), rs.getInt(3));
        }

        public AlarmState getAlarmState() {
            return this.m_alarmState;
        }
    }
}

