/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.dao.api.MicroblogConfigurationDao;
import org.opennms.netmgt.dao.jaxb.DefaultMicroblogConfigurationDao;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.MicroblogClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class MicroblogNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MicroblogNotificationStrategy.class);
    private static final String UBLOG_PROFILE_NAME = "notifd";
    protected MicroblogConfigurationDao m_microblogConfigurationDao;
    protected MicroblogConfigurationDao m_configDao = new DefaultMicroblogConfigurationDao();

    public MicroblogNotificationStrategy() throws IOException {
        this(MicroblogNotificationStrategy.findDefaultConfigResource());
    }

    public MicroblogNotificationStrategy(Resource configResource) {
        ((DefaultMicroblogConfigurationDao)this.m_configDao).setConfigResource(configResource);
        ((DefaultMicroblogConfigurationDao)this.m_configDao).afterPropertiesSet();
        this.setMicroblogConfigurationDao(this.m_configDao);
    }

    public int send(List<Argument> arguments) {
        Status response;
        Twitter svc = this.buildUblogService(arguments);
        String messageBody = this.buildMessageBody(arguments);
        String baseURL = svc.getConfiguration().getClientURL();
        LOG.debug("Dispatching microblog notification at base URL '{}' with message '{}'", (Object)baseURL, (Object)messageBody);
        try {
            response = svc.updateStatus(messageBody);
        }
        catch (TwitterException e) {
            LOG.error("Microblog notification failed at service URL '{}'", (Object)baseURL, (Object)e);
            return 1;
        }
        LOG.info("Microblog notification succeeded: update posted with ID {}", (Object)response.getId());
        return 0;
    }

    protected Twitter buildUblogService(List<Argument> arguments) {
        MicroblogClient client = new MicroblogClient(this.m_microblogConfigurationDao);
        if (!client.isOAuthUsable(UBLOG_PROFILE_NAME) && !client.hasBasicAuth(UBLOG_PROFILE_NAME)) {
            throw new RuntimeException("No profile with OAuth or password authentication configured!  Edit your microblog-configuration.xml!");
        }
        return client.getTwitter(UBLOG_PROFILE_NAME);
    }

    protected String buildMessageBody(List<Argument> arguments) {
        String messageBody = null;
        for (Argument arg : arguments) {
            if ("-tm".equals(arg.getSwitch())) {
                messageBody = arg.getValue();
                continue;
            }
            if (!"-nm".equals(arg.getSwitch()) || messageBody != null) continue;
            messageBody = arg.getValue();
        }
        if (messageBody == null) {
            throw new IllegalArgumentException("No message specified, but is required");
        }
        messageBody = messageBody.replaceAll("\\s+", " ");
        LOG.debug("Final message body after collapsing whitespace is: '{}'", (Object)messageBody);
        return messageBody;
    }

    protected String findDestName(List<Argument> arguments) {
        for (Argument arg : arguments) {
            if (!"-ublog".equals(arg.getSwitch())) continue;
            LOG.debug("Found destination microblog name: {}", (Object)arg.getSwitch());
            return arg.getValue();
        }
        LOG.debug("No destination microblog name found");
        return null;
    }

    protected static Resource findDefaultConfigResource() throws IOException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MICROBLOG_CONFIG_FILE_NAME);
        return new FileSystemResource(configFile);
    }

    public void setMicroblogConfigurationDao(MicroblogConfigurationDao dao) {
        this.m_microblogConfigurationDao = dao;
    }

    public MicroblogConfigurationDao getMicroblogConfigurationDao() {
        return this.m_microblogConfigurationDao;
    }
}

