/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.dao.api.DefaultAlarmEntityListener;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class NorthbounderManager
extends DefaultAlarmEntityListener {
    private static final Logger LOG = LoggerFactory.getLogger(NorthbounderManager.class);
    private List<Northbounder> m_northboundInterfaces = new ArrayList<Northbounder>();
    private volatile boolean m_hasActiveAlarmNbis = false;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    public void onAlarmCreated(OnmsAlarm alarm) {
        this.forwardAlarmToNbis(alarm);
    }

    public void onAlarmUpdatedWithReducedEvent(OnmsAlarm alarm) {
        this.forwardAlarmToNbis(alarm);
    }

    private synchronized void forwardAlarmToNbis(OnmsAlarm alarm) {
        NorthboundAlarm a = new NorthboundAlarm(alarm);
        for (Northbounder nbi : this.m_northboundInterfaces) {
            nbi.onAlarm(a);
        }
    }

    public synchronized void onNorthbounderRegistered(Northbounder northbounder, Map<String, String> properties) {
        LOG.debug("onNorthbounderRegistered: starting {}", (Object)northbounder.getName());
        northbounder.start();
        this.m_northboundInterfaces.add(northbounder);
        this.onNorthboundersChanged();
    }

    public synchronized void onNorthbounderUnregistered(Northbounder northbounder, Map<String, String> properties) {
        LOG.debug("onNorthbounderUnregistered: stopping {}", (Object)northbounder.getName());
        northbounder.stop();
        this.m_northboundInterfaces.remove(northbounder);
        this.onNorthboundersChanged();
    }

    private void onNorthboundersChanged() {
        long numNbisActive = this.m_northboundInterfaces.stream().filter(Northbounder::isReady).count();
        this.m_hasActiveAlarmNbis = numNbisActive > 0L;
        LOG.debug("handleNorthboundersChanged: {} out of {} NBIs are currently active.", (Object)numNbisActive, (Object)this.m_northboundInterfaces.size());
    }

    public synchronized List<Northbounder> getNorthboundInterfaces() {
        return Collections.unmodifiableList(this.m_northboundInterfaces);
    }

    public synchronized void setNorthboundInterfaces(List<Northbounder> northboundInterfaces) {
        this.m_northboundInterfaces = northboundInterfaces;
        this.onNorthboundersChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReloadEvent(IEvent e) {
        List parmCollection = e.getParmCollection();
        for (IParm parm : parmCollection) {
            String parmName = parm.getParmName();
            if (!"daemonName".equals(parmName)) continue;
            if (parm.getValue() == null || parm.getValue().getContent() == null) {
                LOG.warn("The daemonName parameter has no value, ignoring.");
                return;
            }
            String daemonName = parm.getValue().getContent();
            List<Northbounder> nbis = this.getNorthboundInterfaces();
            for (Northbounder nbi : nbis) {
                if (!daemonName.contains(nbi.getName())) continue;
                LOG.debug("Handling reload event for NBI: {}", (Object)nbi.getName());
                LOG.debug("Reloading NBI configuration for interface {} not yet implemented.", (Object)nbi.getName());
                EventBuilder ebldr = null;
                try {
                    nbi.reloadConfig();
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "alarmd");
                    ebldr.addParam("daemonName", "alarmd");
                }
                catch (NorthbounderException ex) {
                    LOG.error("Can't reload the northbound configuration for " + nbi.getName(), (Throwable)ex);
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "alarmd");
                    ebldr.addParam("daemonName", "alarmd");
                    ebldr.addParam("reason", ex.getMessage());
                }
                finally {
                    if (ebldr != null) {
                        try {
                            this.m_eventProxy.send(ebldr.getEvent());
                        }
                        catch (EventProxyException ep) {
                            LOG.error("Can't send reload status event", (Throwable)ep);
                        }
                    }
                }
                return;
            }
        }
    }

    public void stop() {
        this.m_northboundInterfaces.forEach(nb -> {
            LOG.debug("destroy: stopping {}", (Object)nb.getName());
            nb.stop();
        });
    }

    public synchronized void onAlarmCreatedOrUpdatedWithReducedEvent(OnmsAlarm alarm) {
        if (this.m_hasActiveAlarmNbis) {
            NorthboundAlarm a = new NorthboundAlarm(alarm);
            for (Northbounder nbi : this.m_northboundInterfaces) {
                nbi.onAlarm(a);
            }
        }
    }
}

