/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.Assert;

public class SubscriptionMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static final Log logger = LogFactory.getLog(SubscriptionMethodReturnValueHandler.class);
    private final MessageSendingOperations<String> messagingTemplate;
    private MessageHeaderInitializer headerInitializer;

    public SubscriptionMethodReturnValueHandler(MessageSendingOperations<String> messagingTemplate) {
        Assert.notNull(messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getMethodAnnotation(SubscribeMapping.class) != null && returnType.getMethodAnnotation(SendTo.class) == null && returnType.getMethodAnnotation(SendToUser.class) == null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        if (returnValue == null) {
            return;
        }
        MessageHeaders headers = message.getHeaders();
        String destination = SimpMessageHeaderAccessor.getDestination(headers);
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        String subscriptionId = SimpMessageHeaderAccessor.getSubscriptionId(headers);
        if (subscriptionId == null) {
            throw new IllegalStateException("No subscriptionId in " + message + " returned by: " + returnType.getMethod());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reply to @SubscribeMapping: " + returnValue));
        }
        this.messagingTemplate.convertAndSend(destination, returnValue, this.createHeaders(sessionId, subscriptionId, returnType));
    }

    private MessageHeaders createHeaders(String sessionId, String subscriptionId, MethodParameter returnType) {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create(SimpMessageType.MESSAGE);
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(headerAccessor);
        }
        headerAccessor.setSessionId(sessionId);
        headerAccessor.setSubscriptionId(subscriptionId);
        headerAccessor.setHeader("conversionHint", returnType);
        headerAccessor.setLeaveMutable(true);
        return headerAccessor.getMessageHeaders();
    }
}

