/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db.install;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Trigger {
    private String m_name;
    private String m_table;
    private String m_storedProcedure;
    private String m_sql;
    private static Pattern m_pattern = Pattern.compile("(?i)(CREATE TRIGGER (\\S+)\\s+BEFORE (?:INSERT|UPDATE|INSERT OR UPDATE)\\s+ON (\\S+) FOR EACH ROW\\s+EXECUTE PROCEDURE (\\S+)\\(\\));");

    public Trigger(String name, String table, String storedProcedure, String sql) {
        this.m_name = name;
        this.m_table = table;
        this.m_storedProcedure = storedProcedure;
        this.m_sql = sql;
    }

    public static Trigger findTriggerInString(String create) {
        Matcher m = m_pattern.matcher(create);
        if (!m.find()) {
            return null;
        }
        String sql = m.group(1);
        String name = m.group(2);
        String table = m.group(3);
        String storedProcedure = m.group(4);
        return new Trigger(name, table, storedProcedure, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnDatabase(Connection connection) throws SQLException {
        boolean exists;
        Statement st = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT oid FROM pg_trigger WHERE tgname = '" + this.m_name.toLowerCase() + "' AND tgrelid = (SELECT oid FROM pg_class WHERE relname = '" + this.m_table.toLowerCase() + "' ) AND tgfoid = (SELECT oid FROM pg_proc WHERE proname = '" + this.m_storedProcedure.toLowerCase() + "')");
            exists = rs.next();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return exists;
    }

    public void removeFromDatabase(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            st.execute("DROP TRIGGER " + this.getName() + " ON " + this.getTable());
        }
    }

    public void addToDatabase(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            st.execute(this.getSql());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getSql() {
        return this.m_sql;
    }

    public String getStoredProcedure() {
        return this.m_storedProcedure;
    }

    public String getTable() {
        return this.m_table;
    }
}

