/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.LazyStringBuilder;
import org.jivesoftware.smack.util.StringUtils;

public class XmlStringBuilder
implements Appendable,
CharSequence {
    public static final String RIGHT_ANGEL_BRACKET = Character.toString('>');
    private final LazyStringBuilder sb = new LazyStringBuilder();

    public XmlStringBuilder() {
    }

    public XmlStringBuilder(PacketExtension pe) {
        this();
        this.prelude(pe);
    }

    public XmlStringBuilder element(String name, String content) {
        assert (content != null);
        this.openElement(name);
        this.escape(content);
        this.closeElement(name);
        return this;
    }

    public XmlStringBuilder element(String name, Enum<?> content) {
        assert (content != null);
        this.element(name, content.name());
        return this;
    }

    public XmlStringBuilder optElement(String name, String content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder optElement(String name, Enum<?> content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder halfOpenElement(String name) {
        this.sb.append('<').append(name);
        return this;
    }

    public XmlStringBuilder openElement(String name) {
        this.halfOpenElement(name).rightAngelBracket();
        return this;
    }

    public XmlStringBuilder closeElement(String name) {
        this.sb.append("</").append(name);
        this.rightAngelBracket();
        return this;
    }

    public XmlStringBuilder closeElement(PacketExtension pe) {
        this.closeElement(pe.getElementName());
        return this;
    }

    public XmlStringBuilder closeEmptyElement() {
        this.sb.append("/>");
        return this;
    }

    public XmlStringBuilder rightAngelBracket() {
        this.sb.append(RIGHT_ANGEL_BRACKET);
        return this;
    }

    public XmlStringBuilder attribute(String name, String value) {
        assert (value != null);
        this.sb.append(' ').append(name).append("='");
        this.escape(value);
        this.sb.append('\'');
        return this;
    }

    public XmlStringBuilder attribute(String name, Enum<?> value) {
        assert (value != null);
        this.attribute(name, value.name());
        return this;
    }

    public XmlStringBuilder optAttribute(String name, String value) {
        if (value != null) {
            this.attribute(name, value);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, Enum<?> value) {
        if (value != null) {
            this.attribute(name, value.name());
        }
        return this;
    }

    public XmlStringBuilder xmlnsAttribute(String value) {
        this.optAttribute("xmlns", value);
        return this;
    }

    public XmlStringBuilder xmllangAttribute(String value) {
        this.optAttribute("xml:lang", value);
        return this;
    }

    public XmlStringBuilder escape(String text) {
        assert (text != null);
        this.sb.append(StringUtils.escapeForXML(text));
        return this;
    }

    public XmlStringBuilder prelude(PacketExtension pe) {
        this.halfOpenElement(pe.getElementName());
        this.xmlnsAttribute(pe.getNamespace());
        return this;
    }

    public XmlStringBuilder optAppend(CharSequence csq) {
        if (csq != null) {
            this.append(csq);
        }
        return this;
    }

    public XmlStringBuilder append(XmlStringBuilder xsb) {
        assert (xsb != null);
        this.sb.append(xsb.sb);
        return this;
    }

    public XmlStringBuilder emptyElement(String element) {
        this.halfOpenElement(element);
        return this.closeEmptyElement();
    }

    public XmlStringBuilder condEmptyElement(boolean condition, String element) {
        if (condition) {
            this.emptyElement(element);
        }
        return this;
    }

    public XmlStringBuilder condAttribute(boolean condition, String name, String value) {
        if (condition) {
            this.attribute(name, value);
        }
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence csq) {
        assert (csq != null);
        this.sb.append(csq);
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence csq, int start, int end) {
        assert (csq != null);
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public XmlStringBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof XmlStringBuilder)) {
            return false;
        }
        XmlStringBuilder otherXmlStringBuilder = (XmlStringBuilder)other;
        return this.toString().equals(otherXmlStringBuilder.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

