/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.pathoutage;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleSearchProvider;
import org.opennms.features.topology.plugins.topo.pathoutage.PathOutageProvider;
import org.opennms.features.topology.plugins.topo.pathoutage.PathOutageVertex;

public class PathOutageSearchProvider
extends SimpleSearchProvider {
    private final PathOutageProvider pathOutageProvider;

    public PathOutageSearchProvider(PathOutageProvider provider) {
        this.pathOutageProvider = provider;
    }

    public String getSearchProviderNamespace() {
        return "pathoutage";
    }

    public List<? extends VertexRef> queryVertices(SearchQuery searchQuery, GraphContainer container) {
        Objects.requireNonNull(searchQuery);
        Objects.requireNonNull(container);
        ArrayList results = new ArrayList();
        String queryString = searchQuery.getQueryString();
        this.pathOutageProvider.getCurrentGraph().getVertices(new Criteria[0]).stream().filter(v -> PathOutageSearchProvider.matches((PathOutageVertex)((Object)v), queryString)).forEach(v -> results.add((PathOutageVertex)((Object)v)));
        return results;
    }

    private static boolean matches(PathOutageVertex vertex, String searchQuery) {
        return vertex.getLabel().contains(searchQuery);
    }
}

