/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.jfree.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.opennms.shaded.jasper.org.jfree.chart.HashUtilities;
import org.opennms.shaded.jasper.org.jfree.chart.plot.dial.AbstractDialLayer;
import org.opennms.shaded.jasper.org.jfree.chart.plot.dial.DialLayer;
import org.opennms.shaded.jasper.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import org.opennms.shaded.jasper.org.jfree.chart.plot.dial.DialPlot;
import org.opennms.shaded.jasper.org.jfree.chart.util.ParamChecks;

public class DialCap
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -2929484264982524463L;
    private double radius = 0.05;
    private transient Paint fillPaint = Color.white;
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(2.0f);

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Requires radius > 0.0.");
        }
        this.radius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.fillPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.outlinePaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.outlineStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        g2.setPaint(this.fillPaint);
        Rectangle2D f = DialPlot.rectangleByRadius(frame, this.radius, this.radius);
        Ellipse2D.Double e = new Ellipse2D.Double(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        g2.fill(e);
        g2.setPaint(this.outlinePaint);
        g2.setStroke(this.outlineStroke);
        g2.draw(e);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DialCap)) {
            return false;
        }
        DialCap that = (DialCap)obj;
        if (this.radius != that.radius) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.fillPaint, (Paint)that.fillPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.outlinePaint, (Paint)that.outlinePaint)) {
            return false;
        }
        if (!this.outlineStroke.equals(that.outlineStroke)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = 193;
        result = 37 * result + HashUtilities.hashCodeForPaint(this.fillPaint);
        result = 37 * result + HashUtilities.hashCodeForPaint(this.outlinePaint);
        result = 37 * result + this.outlineStroke.hashCode();
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.fillPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.fillPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
    }
}

