/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml.validators;

import java.math.BigInteger;
import org.opennms.shaded.jasper.org.exolab.castor.xml.TypeValidator;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationContext;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationException;
import org.opennms.shaded.jasper.org.exolab.castor.xml.validators.PatternValidator;

public class BigIntegerValidator
extends PatternValidator
implements TypeValidator {
    private boolean _useMin = false;
    private boolean _useMax = false;
    private boolean _useFixed = false;
    private BigInteger _min = BigInteger.valueOf(0L);
    private BigInteger _max = BigInteger.valueOf(0L);
    private int _totalDigits = -1;
    private BigInteger _fixed = BigInteger.valueOf(0L);

    public void clearFixed() {
        this._useFixed = false;
    }

    public void clearMax() {
        this._useMax = false;
    }

    public void clearMin() {
        this._useMin = false;
    }

    public BigInteger getFixed() {
        if (this._useFixed) {
            return this._fixed;
        }
        return null;
    }

    public BigInteger getMaxInclusive() {
        if (this._useMax) {
            return this._max;
        }
        return null;
    }

    public BigInteger getMinInclusive() {
        if (this._useMin) {
            return this._min;
        }
        return null;
    }

    public Integer getTotalDigits() {
        if (this._totalDigits >= 0) {
            return this._totalDigits;
        }
        return null;
    }

    public boolean hasFixed() {
        return this._useFixed;
    }

    public void setFixed(BigInteger fixedValue) {
        this._useFixed = true;
        this._fixed = fixedValue;
    }

    public void setMinExclusive(BigInteger minValue) {
        this._useMin = true;
        this._min = minValue.add(BigInteger.valueOf(1L));
    }

    public void setMinInclusive(BigInteger minValue) {
        this._useMin = true;
        this._min = minValue;
    }

    public void setMaxExclusive(BigInteger maxValue) {
        this._useMax = true;
        this._max = maxValue.subtract(BigInteger.valueOf(-1L));
    }

    public void setMaxInclusive(BigInteger maxValue) {
        this._useMax = true;
        this._max = maxValue;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException("IntegerValidator: the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void validate(BigInteger value, ValidationContext context) throws ValidationException {
        if (this._useFixed && value != this._fixed) {
            String err = "BigInteger " + value + " is not equal to the fixed value: " + this._fixed;
            throw new ValidationException(err);
        }
        if (this._useMin && value.compareTo(this._min) == -1) {
            String err = "BigInteger " + value + " is less than the minimum allowed value: " + this._min;
            throw new ValidationException(err);
        }
        if (this._useMax && value.compareTo(this._max) == 1) {
            String err = "BigInteger " + value + " is greater than the maximum allowed value: " + this._max;
            throw new ValidationException(err);
        }
        if (this._totalDigits != -1) {
            int length = value.toString().length();
            if (value.compareTo(new BigInteger("0")) == -1) {
                --length;
            }
            if (length > this._totalDigits) {
                String err = "BigInteger " + value + " has too many digits -- must have " + this._totalDigits + " digits or fewer.";
                throw new ValidationException(err);
            }
        }
        if (this.hasPattern()) {
            super.validate(value.toString(), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "BigIntegerValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        BigInteger value = BigInteger.valueOf(0L);
        try {
            value = (BigInteger)object;
        }
        catch (Exception ex) {
            String err = "Expecting a BigInteger, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value, context);
    }
}

