/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.xml;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.xml.BackwardCompatibilityContext;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.FieldDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.xml.FieldValidator;
import org.opennms.shaded.jasper.org.exolab.castor.xml.MarshalFramework;
import org.opennms.shaded.jasper.org.exolab.castor.xml.NodeType;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ResolverException;
import org.opennms.shaded.jasper.org.exolab.castor.xml.TypeValidator;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationContext;
import org.opennms.shaded.jasper.org.exolab.castor.xml.ValidationException;
import org.opennms.shaded.jasper.org.exolab.castor.xml.XMLClassDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.xml.XMLFieldDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.xml.location.XPathLocation;
import org.opennms.shaded.jasper.org.exolab.castor.xml.validators.ClassValidator;

public class Validator
implements ClassValidator {
    private static final Log LOG = LogFactory.getLog(Validator.class);
    protected static ResourceBundle resourceBundle = ResourceBundle.getBundle("ValidationMessages", Locale.getDefault());

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            throw new ValidationException(resourceBundle.getString("validator.error.cannot.validate.null.object"));
        }
        if (context == null) {
            ValidationContext v2 = new ValidationContext();
            BackwardCompatibilityContext ic = new BackwardCompatibilityContext();
            ic.setClassLoader(object.getClass().getClassLoader());
            v2.setInternalContext(ic);
            this.validate(object, v2);
            return;
        }
        if (context.getClassDescriptorResolver() == null) {
            String message = resourceBundle.getString("validator.error.class.descriptor.resolver.null");
            throw new IllegalStateException(message);
        }
        XMLClassDescriptor classDesc = null;
        if (!MarshalFramework.isPrimitive(object.getClass())) {
            try {
                classDesc = (XMLClassDescriptor)context.getClassDescriptorResolver().resolve(object.getClass());
            }
            catch (ResolverException rx) {
                throw new ValidationException((Throwable)((Object)rx));
            }
        }
        if (classDesc == null) {
            return;
        }
        XMLFieldDescriptor fieldDesc = null;
        try {
            TypeValidator validator = classDesc.getValidator();
            if (validator != null) {
                validator.validate(object, context);
            } else {
                FieldDescriptor[] fields = classDesc.getFields();
                if (fields != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        FieldValidator fieldValidator;
                        fieldDesc = (XMLFieldDescriptor)fields[i];
                        if (fieldDesc == null || (fieldValidator = fieldDesc.getValidator()) == null) continue;
                        fieldValidator.validate(object, context);
                    }
                }
            }
        }
        catch (ValidationException vx) {
            XPathLocation loc = (XPathLocation)vx.getLocation();
            if (loc == null) {
                loc = new XPathLocation();
                vx.setLocation(loc);
                if (fieldDesc != null) {
                    if (fieldDesc.getNodeType() == NodeType.Attribute) {
                        loc.addAttribute(fieldDesc.getXMLName());
                    } else {
                        loc.addChild(fieldDesc.getXMLName());
                    }
                }
            }
            if (classDesc.getXMLName() != null) {
                loc.addParent(classDesc.getXMLName());
            }
            throw vx;
        }
    }

    public void checkUnresolvedIdrefs(ValidationContext context) throws ValidationException {
        if (!context.getUnresolvedIdRefs().isEmpty()) {
            String err = MessageFormat.format(resourceBundle.getString("validator.error.class.descriptor.resolver.null"), context.getUnresolvedIdRefs().toString());
            throw new ValidationException(err);
        }
    }
}

