/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opennms.shaded.jasper.org.exolab.castor.types.DateTimeBase;

public class GMonthDay
extends DateTimeBase {
    private static final long serialVersionUID = -6351252242146921258L;
    private static final String MONTHDAY_FORMAT = "--MM-dd";
    private static final String BAD_GMONTHDAY = "Bad gMonthDay format: ";

    public GMonthDay() {
    }

    public GMonthDay(short month, short day) {
        this.setMonth(month);
        this.setDay(day);
    }

    public GMonthDay(int month, int day) {
        this.setMonth((short)month);
        this.setDay((short)day);
    }

    public GMonthDay(short[] values) {
        this.setValues(values);
    }

    public GMonthDay(String gmonthDay) throws ParseException {
        GMonthDay.parseGMonthDayInternal(gmonthDay, this);
    }

    @Override
    public void setValues(short[] values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("GMonthDay#setValues: not the right number of values");
        }
        this.setMonth(values[0]);
        this.setDay(values[1]);
    }

    @Override
    public short[] getValues() {
        short[] result = new short[]{this.getMonth(), this.getDay()};
        return result;
    }

    @Override
    public Date toDate() {
        SimpleDateFormat df = new SimpleDateFormat(MONTHDAY_FORMAT);
        this.setDateFormatTimeZone(df);
        Date date = null;
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("--");
        if (this.getMonth() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMonth());
        result.append("-");
        if (this.getDay() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getDay());
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GMonthDay.parseGMonthDay(str);
    }

    public static GMonthDay parseGMonthDay(String str) throws ParseException {
        return GMonthDay.parseGMonthDayInternal(str, null);
    }

    private static GMonthDay parseGMonthDayInternal(String str, GMonthDay result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GMonthDay();
        }
        if ((chars = str.toCharArray())[idx = 0] != '-' || chars[idx + 1] != '-') {
            throw new ParseException(BAD_GMONTHDAY + str + "\nA gMonthDay must follow the pattern --MM-DD(Z|((+|-)hh:mm)).", 0);
        }
        if (!Character.isDigit(chars[idx += 2]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(BAD_GMONTHDAY + str + "\nThe Month must be 2 digits long", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setMonth(value1);
        if (chars[idx += 2] != '-') {
            throw new ParseException(BAD_GMONTHDAY + str + "\nA gMonthDay must follow the pattern --MM-DD(Z|((+|-)hh:mm)).", 0);
        }
        if (!Character.isDigit(chars[++idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(BAD_GMONTHDAY + str + "\nThe Day must be 2 digits long", idx);
        }
        value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setDay(value1);
        GMonthDay.parseTimeZone(str, result, chars, idx += 2, BAD_GMONTHDAY);
        return result;
    }

    @Override
    public boolean hasIsNegative() {
        return false;
    }

    @Override
    public boolean isNegative() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a 'negative' field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setNegative() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay cannot be negative.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasCentury() {
        return false;
    }

    @Override
    public short getCentury() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Century field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setCentury(short century) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Century field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasYear() {
        return false;
    }

    @Override
    public short getYear() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Year field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setYear(short year) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Year field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasHour() {
        return false;
    }

    @Override
    public short getHour() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have an Hour field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setHour(short hour) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have an Hour field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMinute() {
        return false;
    }

    @Override
    public short getMinute() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Minute field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMinute(short minute) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Minute field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasSeconds() {
        return false;
    }

    @Override
    public short getSeconds() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Seconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setSecond(short second) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Seconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMilli() {
        return false;
    }

    @Override
    public short getMilli() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Milliseconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMilliSecond(short millisecond) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.GMonthDay does not have a Milliseconds field.";
        throw new UnsupportedOperationException(err);
    }
}

