/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.dsml;

import org.opennms.shaded.jasper.org.exolab.castor.dsml.ImportDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.dsml.SearchDescriptor;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public abstract class Producer {
    protected DocumentHandler _docHandler;
    private boolean _namespace;
    private boolean _insideDirectory;
    private boolean _insideSchema;

    public Producer(DocumentHandler docHandler, boolean namespace) {
        this._docHandler = docHandler;
        this._namespace = namespace;
    }

    public void startDocument() throws SAXException {
        AttributeListImpl attrList = new AttributeListImpl();
        if (this._namespace) {
            attrList.addAttribute("xmlns:dsml", "CDATA", "http://www.dsml.org/DSML");
        } else {
            attrList.addAttribute("xmlns", "CDATA", "http://www.dsml.org/DSML");
        }
        this._docHandler.startElement(this.prefix("dsml"), attrList);
    }

    public void endDocument() throws SAXException {
        this.leaveDirectory();
        this.leaveSchema();
        this._docHandler.endElement(this.prefix("dsml"));
    }

    public void produce(ImportDescriptor importDesc) throws SAXException {
        this.leaveDirectory();
        this.leaveSchema();
        importDesc.produce(this._docHandler);
    }

    public void produce(SearchDescriptor searchDesc) throws SAXException {
        this.leaveDirectory();
        this.leaveSchema();
        searchDesc.produce(this._docHandler);
    }

    protected void enterDirectory() throws SAXException {
        if (!this._insideDirectory) {
            this._insideDirectory = true;
            this._docHandler.startElement(this.prefix("directory-entries"), new AttributeListImpl());
        }
    }

    protected void leaveDirectory() throws SAXException {
        if (this._insideDirectory) {
            this._insideDirectory = false;
            this._docHandler.endElement(this.prefix("directory-entries"));
        }
    }

    protected void enterSchema() throws SAXException {
        if (!this._insideSchema) {
            this._insideSchema = true;
            this._docHandler.startElement(this.prefix("directory-schema"), new AttributeListImpl());
        }
    }

    protected void leaveSchema() throws SAXException {
        if (this._insideSchema) {
            this._insideSchema = false;
            this._docHandler.endElement(this.prefix("directory-schema"));
        }
    }

    protected String prefix(String tagName) {
        if (this._namespace) {
            return "dsml:" + tagName;
        }
        return tagName;
    }
}

