/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.StyledTextListInfo;
import net.sf.jasperreports.engine.util.StyledTextListItemInfo;
import net.sf.jasperreports.engine.util.StyledTextListWriter;

public class StyledTextWriteContext {
    private StyledTextListInfo[] prevListStack;
    private StyledTextListItemInfo prevListItem;
    private StyledTextListInfo[] listStack;
    private StyledTextListItemInfo listItem;
    private boolean isFirstRun = true;
    private boolean runTextEndedWithNewLine = false;
    private boolean prevRunTextEndedWithNewLine = false;
    private boolean runTextStartsWithNewLine = false;
    private int prevDepth = 0;
    private int newDepth = 0;
    private int commonListDepth = 0;
    private boolean isProcessingCuts = false;

    public StyledTextWriteContext() {
    }

    public StyledTextWriteContext(boolean isProcessingCuts) {
        this.isProcessingCuts = isProcessingCuts;
    }

    public boolean isFirstRun() {
        return this.isFirstRun;
    }

    public StyledTextListInfo getPrevList(int index) {
        return this.prevListStack == null || this.prevListStack.length == 0 ? null : this.prevListStack[index];
    }

    public StyledTextListInfo getPrevList() {
        return this.prevListStack == null || this.prevListStack.length == 0 ? null : this.prevListStack[this.prevListStack.length - 1];
    }

    public StyledTextListInfo getList(int index) {
        return this.listStack == null || this.listStack.length == 0 ? null : this.listStack[index];
    }

    public StyledTextListInfo getList() {
        return this.listStack == null || this.listStack.length == 0 ? null : this.listStack[this.listStack.length - 1];
    }

    public StyledTextListItemInfo getListItem() {
        return this.listItem;
    }

    public boolean prevListItemEndedWithNewLine() {
        return this.prevRunTextEndedWithNewLine;
    }

    public boolean listItemStartsWithNewLine() {
        return this.runTextStartsWithNewLine;
    }

    public int getPrevDepth() {
        return this.prevDepth;
    }

    public int getDepth() {
        return this.newDepth;
    }

    public int getCommonListDepth() {
        return this.commonListDepth;
    }

    public boolean isListStart() {
        return this.commonListDepth + 1 == this.newDepth;
    }

    public boolean isListEnd() {
        return this.commonListDepth + 1 == this.prevDepth;
    }

    public boolean isListItemStart() {
        return this.listItem != null && this.listItem != StyledTextListItemInfo.NO_LIST_ITEM_FILLER && this.listItem != this.prevListItem && (this.prevDepth <= this.newDepth || this.commonListDepth == this.newDepth && (!this.prevListStack[this.commonListDepth].hasParentLi() || this.prevListStack[this.commonListDepth].atLiEnd()) || this.commonListDepth < this.newDepth);
    }

    public boolean isListItemEnd() {
        return this.prevListItem != null && this.prevListItem != StyledTextListItemInfo.NO_LIST_ITEM_FILLER && this.prevListItem != this.listItem && (this.prevDepth >= this.newDepth || this.commonListDepth == this.prevDepth && (!this.listStack[this.commonListDepth].hasParentLi() || this.listStack[this.commonListDepth].atLiStart()) || this.commonListDepth < this.prevDepth);
    }

    public boolean isListItemChange() {
        return this.listItem != this.prevListItem;
    }

    public void next(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        this.prevListStack = this.listStack;
        this.prevListItem = this.listItem;
        if (attributes == null) {
            this.listStack = null;
            this.listItem = null;
        } else {
            this.listStack = (StyledTextListInfo[])attributes.get(JRTextAttribute.HTML_LIST);
            this.listItem = (StyledTextListItemInfo)attributes.get(JRTextAttribute.HTML_LIST_ITEM);
        }
        this.prevDepth = this.prevListStack == null ? 0 : this.prevListStack.length;
        this.newDepth = this.listStack == null ? 0 : this.listStack.length;
        int minDepth = Math.min(this.prevDepth, this.newDepth);
        this.commonListDepth = 0;
        while (this.commonListDepth < minDepth && this.listStack[this.commonListDepth] == this.prevListStack[this.commonListDepth]) {
            ++this.commonListDepth;
        }
        if (this.isProcessingCuts) {
            if (this.isFirstRun && this.listStack != null) {
                for (StyledTextListInfo list : this.listStack) {
                    list.setCutStart(list.getStart() + list.getItemIndex());
                }
            }
            if (this.isListItemStart()) {
                StyledTextListInfo list = this.getList();
                if (this.getList() != null && this.getList().ordered()) {
                    list.setItemIndex(this.getListItem().getItemIndex());
                }
            }
        }
        this.isFirstRun = false;
    }

    public void next(Map<AttributedCharacterIterator.Attribute, Object> attributes, String runText) {
        this.next(attributes);
        this.prevRunTextEndedWithNewLine = this.runTextEndedWithNewLine;
        this.runTextEndedWithNewLine = runText == null ? false : runText.endsWith("\n");
        this.runTextStartsWithNewLine = runText == null ? false : runText.startsWith("\n");
    }

    public void writeLists(StyledTextListWriter writer) {
        int i;
        if (writer == null) {
            return;
        }
        if (this.isListItemEnd()) {
            writer.endLi();
        }
        for (i = this.getPrevDepth() - 1; i > this.getCommonListDepth(); --i) {
            StyledTextListInfo prevList = this.getPrevList(i);
            if (prevList.ordered()) {
                writer.endOl();
            } else {
                writer.endUl();
            }
            if (!prevList.hasParentLi()) continue;
            writer.endLi();
        }
        if (this.getPrevDepth() > this.getCommonListDepth()) {
            StyledTextListInfo prevList = this.getPrevList(this.getCommonListDepth());
            if (prevList.ordered()) {
                writer.endOl();
            } else {
                writer.endUl();
            }
            if (prevList.hasParentLi() && prevList.atLiEnd()) {
                writer.endLi();
            }
        }
        if (this.getCommonListDepth() < this.getDepth()) {
            StyledTextListInfo list = this.getList(this.getCommonListDepth());
            if (list.hasParentLi() && list.atLiStart()) {
                writer.startLi(true);
            }
            if (list.ordered()) {
                writer.startOl(list.getType(), list.getCutStart());
            } else {
                writer.startUl();
            }
        }
        for (i = this.getCommonListDepth() + 1; i < this.getDepth(); ++i) {
            StyledTextListInfo list = this.getList(i);
            if (list.hasParentLi()) {
                writer.startLi(true);
            }
            if (list.ordered()) {
                writer.startOl(list.getType(), list.getCutStart());
                continue;
            }
            writer.startUl();
        }
        if (this.isListItemStart()) {
            writer.startLi(this.getListItem().noBullet());
        }
    }
}

