/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.CachingLineBox;
import net.sf.jasperreports.engine.fill.CachingParagraph;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;
import net.sf.jasperreports.engine.util.StyleUtil;
import net.sf.jasperreports.engine.util.StyledTextListInfo;
import net.sf.jasperreports.engine.util.StyledTextListItemInfo;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    public static final String EXCEPTION_MESSAGE_KEY_MISSING_MARKUP_PROCESSOR_FACTORY = "fill.text.element.missing.markup.processor.factory";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_START_INDEX = "fill.text.element.invalid.start.index";
    public static final String PROPERTY_CONSUME_SPACE_ON_OVERFLOW = "net.sf.jasperreports.consume.space.on.overflow";
    public static final String PROPERTY_SCALE_FONT_STEP_LIMIT = "net.sf.jasperreports.scale.font.step.limit";
    private static final JRSingletonCache<MarkupProcessorFactory> markupProcessorFactoryCache = new JRSingletonCache<MarkupProcessorFactory>(MarkupProcessorFactory.class);
    private static final Map<String, MarkupProcessor> markupProcessors = new HashMap<String, MarkupProcessor>();
    private boolean isLeftToRight = true;
    private JRTextMeasurer textMeasurer;
    private float lineSpacingFactor;
    private float leadingOffset;
    private float textWidth;
    private float textHeight;
    private int textStart;
    private int textEnd;
    private boolean isCutParagraphOverflow;
    private boolean isCutParagraphToContinueInOverflow;
    private short[] lineBreakOffsets;
    private String textTruncateSuffix;
    private String oldRawText;
    private String rawText;
    private JRStyledText styledText;
    private JRStyledText processedStyledText;
    private Map<JRStyle, Map<AttributedCharacterIterator.Attribute, Object>> styledTextAttributesMap = new HashMap<JRStyle, Map<AttributedCharacterIterator.Attribute, Object>>();
    protected final JRLineBox initLineBox;
    protected final JRParagraph initParagraph;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;
    private JRStyle currentFillStyle;
    private FillStyleObjects fillStyleObjects;
    private Map<JRStyle, FillStyleObjects> fillStyleObjectsMap;
    private Boolean defaultConsumeSpaceOnOverflow;
    private boolean dynamicConsumeSpaceOnOverflow;
    private Boolean defaultKeepFullText;
    private boolean dynamicKeepFullText;
    private Float defaultScaleFontStepLimit;
    private boolean dynamicScaleFontStepLimit;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.initLineBox = textElement.getLineBox().clone(this);
        this.initParagraph = textElement.getParagraph().clone(this);
        this.dynamicConsumeSpaceOnOverflow = this.hasDynamicProperty(PROPERTY_CONSUME_SPACE_ON_OVERFLOW);
        this.dynamicKeepFullText = this.hasDynamicProperty("net.sf.jasperreports.print.keep.full.text");
        this.dynamicScaleFontStepLimit = this.hasDynamicProperty(PROPERTY_SCALE_FONT_STEP_LIMIT);
        this.fillStyleObjectsMap = new HashMap<JRStyle, FillStyleObjects>();
    }

    protected JRFillTextElement(JRFillTextElement textElement, JRFillCloneFactory factory) {
        super(textElement, factory);
        this.initLineBox = textElement.getLineBox().clone(this);
        this.initParagraph = textElement.getParagraph().clone(this);
        this.defaultConsumeSpaceOnOverflow = textElement.defaultConsumeSpaceOnOverflow;
        this.dynamicConsumeSpaceOnOverflow = textElement.dynamicConsumeSpaceOnOverflow;
        this.defaultKeepFullText = textElement.defaultKeepFullText;
        this.dynamicKeepFullText = textElement.dynamicKeepFullText;
        this.defaultScaleFontStepLimit = textElement.defaultScaleFontStepLimit;
        this.dynamicScaleFontStepLimit = textElement.dynamicScaleFontStepLimit;
        this.fillStyleObjectsMap = textElement.fillStyleObjectsMap;
    }

    private void createTextMeasurer() {
        this.textMeasurer = JRTextMeasurerUtil.getInstance(this.filler.getJasperReportsContext()).createTextMeasurer(this);
    }

    protected void ensureTextMeasurer() {
        if (this.textMeasurer == null) {
            this.createTextMeasurer();
        }
    }

    @Override
    protected void evaluateStyle(byte evaluation) throws JRException {
        super.evaluateStyle(evaluation);
        if (this.providerStyle == null) {
            this.lineBox = null;
            this.paragraph = null;
            this.setFillStyleObjects();
        } else {
            this.lineBox = this.initLineBox.clone(this);
            this.paragraph = this.initParagraph.clone(this);
            StyleUtil.appendBox(this.lineBox, this.providerStyle.getLineBox());
            StyleUtil.appendParagraph(this.paragraph, this.providerStyle.getParagraph());
            this.fillStyleObjects = null;
        }
    }

    private void setFillStyleObjects() {
        JRStyle evaluatedStyle = this.getStyle();
        if (this.fillStyleObjects != null && this.currentFillStyle == evaluatedStyle) {
            return;
        }
        this.currentFillStyle = evaluatedStyle;
        this.fillStyleObjects = this.fillStyleObjectsMap.get(evaluatedStyle);
        if (this.fillStyleObjects == null) {
            CachingLineBox cachedLineBox = new CachingLineBox(this.initLineBox);
            CachingParagraph cachedParagraph = new CachingParagraph(this.initParagraph);
            this.fillStyleObjects = new FillStyleObjects(cachedLineBox, cachedParagraph);
            this.fillStyleObjectsMap.put(evaluatedStyle, this.fillStyleObjects);
        }
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public HorizontalTextAlignEnum getHorizontalTextAlign() {
        return this.getStyleResolver().getHorizontalTextAlign(this);
    }

    @Override
    public HorizontalTextAlignEnum getOwnHorizontalTextAlign() {
        return this.providerStyle == null || this.providerStyle.getOwnHorizontalTextAlign() == null ? ((JRTextElement)this.parent).getOwnHorizontalTextAlign() : this.providerStyle.getOwnHorizontalTextAlign();
    }

    @Override
    public void setHorizontalTextAlign(HorizontalTextAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalTextAlignEnum getVerticalTextAlign() {
        return this.getStyleResolver().getVerticalTextAlign(this);
    }

    @Override
    public VerticalTextAlignEnum getOwnVerticalTextAlign() {
        return this.providerStyle == null || this.providerStyle.getOwnVerticalTextAlign() == null ? ((JRTextElement)this.parent).getOwnVerticalTextAlign() : this.providerStyle.getOwnVerticalTextAlign();
    }

    @Override
    public void setVerticalTextAlign(VerticalTextAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RotationEnum getRotationValue() {
        return this.getStyleResolver().getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.providerStyle == null || this.providerStyle.getOwnRotationValue() == null ? ((JRTextElement)this.parent).getOwnRotationValue() : this.providerStyle.getOwnRotationValue();
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMarkup() {
        return this.getStyleResolver().getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.providerStyle == null || this.providerStyle.getOwnMarkup() == null ? ((JRTextElement)this.parent).getOwnMarkup() : this.providerStyle.getOwnMarkup();
    }

    @Override
    public void setMarkup(String markup) {
        throw new UnsupportedOperationException();
    }

    protected JRLineBox getPrintLineBox() {
        return this.lineBox == null ? this.initLineBox : this.lineBox;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox == null ? (this.fillStyleObjects == null ? this.initLineBox : this.fillStyleObjects.lineBox) : this.lineBox;
    }

    protected JRParagraph getPrintParagraph() {
        return this.paragraph == null ? this.initParagraph : this.paragraph;
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph == null ? (this.fillStyleObjects == null ? this.initParagraph : this.fillStyleObjects.paragraph) : this.paragraph;
    }

    protected Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes() {
        JRStyle style = this.getStyle();
        Map<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = this.styledTextAttributesMap.get(style);
        if (styledTextAttributes == null) {
            styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            FontUtil.getInstance(this.filler.getJasperReportsContext()).getAttributesWithoutAwtFont(styledTextAttributes, this);
            styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getModeValue() == ModeEnum.OPAQUE) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(style, styledTextAttributes);
        }
        return styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    public RunDirectionEnum getRunDirectionValue() {
        return this.isLeftToRight ? RunDirectionEnum.LTR : RunDirectionEnum.RTL;
    }

    public float getTextWidth() {
        return this.textWidth;
    }

    protected void setTextWidth(float textWidth) {
        this.textWidth = textWidth;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected boolean isCutParagraphToContinueInOverflow() {
        return this.isCutParagraphToContinueInOverflow;
    }

    protected void setCutParagraphToContinueInOverflow(boolean isCutParagraphToContinueInOverflow) {
        this.isCutParagraphToContinueInOverflow = isCutParagraphToContinueInOverflow;
    }

    protected short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    protected void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    protected void resetTextChunk() {
        this.textStart = 0;
        this.textEnd = 0;
        this.textTruncateSuffix = null;
        this.lineBreakOffsets = null;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.oldRawText = this.rawText;
        this.rawText = rawText;
        this.styledText = null;
        this.processedStyledText = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    @Override
    public void rewind() {
        boolean isLegacyBandEvaluationEnabled = this.filler.getFillContext().isLegacyBandEvaluationEnabled();
        if (!isLegacyBandEvaluationEnabled) {
            this.rawText = this.oldRawText;
        }
        this.resetTextChunk();
    }

    protected JRStyledText getStyledText() {
        if (this.styledText == null) {
            String text = this.getRawText();
            if (text != null) {
                this.styledText = this.filler.getStyledTextParser().getStyledText(this.getStyledTextAttributes(), text, !"none".equals(this.getMarkup()), this.filler.getLocale());
            }
            this.processedStyledText = null;
        }
        return this.styledText;
    }

    protected JRStyledText getProcessedStyledText() {
        JRStyledText text;
        if (this.processedStyledText == null && (text = this.getStyledText()) != null) {
            this.processedStyledText = this.filler.getStyledTextUtil().resolveFonts(text, this.filler.getLocale());
        }
        return this.processedStyledText;
    }

    public String getTextString() {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return null;
        }
        return tmpStyledText.getText();
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        this.isCutParagraphOverflow = this.isCutParagraphToContinueInOverflow;
        return super.prepare(availableHeight, isOverflow);
    }

    protected void chopTextElement(int availableStretchHeight) {
        this.ensureTextMeasurer();
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return;
        }
        int fullTextLength = tmpStyledText.getText().length();
        if (this.getTextEnd() == fullTextLength) {
            return;
        }
        boolean canOverflow = this.canOverflow();
        JRStyledText processedText = this.getProcessedStyledText();
        JRMeasuredText measuredText = this.textMeasurer.measure(processedText, this.getTextEnd(), availableStretchHeight, !this.isCutParagraphOverflow, canOverflow);
        if (this.scaleFontToFit() && measuredText.getTextOffset() < fullTextLength) {
            JRStyledText tmpProcessedText = processedText.cloneText();
            JRMeasuredText tmpMeasuredText = measuredText;
            JRMeasuredText lastGoodMeasuredText = measuredText;
            JRMeasuredText lastBadMeasuredText = measuredText;
            float factor = 1.0f;
            float lastGoodFactor = 1.0f;
            float lastBadFactor = 1.0f;
            float delta = 1.0f;
            int deltaSign = -1;
            int oldDeltaSign = -1;
            float oldFontSizeMaxDiff = 0.0f;
            float scaleFontStepLimit = this.scaleFontStepLimit();
            boolean keepMeasuring = true;
            while (keepMeasuring) {
                delta = 0.5f * delta;
                if (tmpMeasuredText.getTextOffset() < fullTextLength) {
                    lastBadMeasuredText = tmpMeasuredText;
                    lastBadFactor = factor;
                    deltaSign = -1;
                    factor -= delta;
                } else {
                    lastGoodMeasuredText = tmpMeasuredText;
                    lastGoodFactor = factor;
                    deltaSign = 1;
                    factor += delta;
                }
                float newFontSizeMaxDiff = JRFillTextElement.alterFontSizes(tmpProcessedText, factor, scaleFontStepLimit);
                boolean bl = keepMeasuring = newFontSizeMaxDiff != 0.0f && (newFontSizeMaxDiff != scaleFontStepLimit || (float)deltaSign * newFontSizeMaxDiff != (float)(-oldDeltaSign) * oldFontSizeMaxDiff);
                if (keepMeasuring) {
                    tmpMeasuredText = this.textMeasurer.measure(tmpProcessedText, this.getTextEnd(), availableStretchHeight, !this.isCutParagraphOverflow, canOverflow);
                }
                oldDeltaSign = deltaSign;
                oldFontSizeMaxDiff = newFontSizeMaxDiff;
            }
            if (lastGoodFactor == 1.0f) {
                lastGoodFactor = lastBadFactor;
                measuredText = lastBadMeasuredText;
            } else {
                measuredText = lastGoodMeasuredText;
            }
            if (!"none".equals(this.getMarkup())) {
                this.styledText = this.styledText.cloneText();
                JRFillTextElement.alterFontSizes(this.styledText, lastGoodFactor, scaleFontStepLimit);
            }
            if (this.providerStyle == null) {
                this.providerStyle = new JRBaseStyle();
            }
            this.providerStyle.setFontSize(Float.valueOf(JRFillTextElement.scaleFontSize(this.getFontsize(), lastGoodFactor, scaleFontStepLimit)));
        }
        this.isLeftToRight = measuredText.isLeftToRight();
        this.setTextWidth(measuredText.getTextWidth());
        this.setTextHeight(measuredText.getTextHeight());
        if (this.getRotationValue().equals(RotationEnum.NONE)) {
            int elementTextHeight = (int)this.getTextHeight() + this.getLineBox().getTopPadding() + this.getLineBox().getBottomPadding();
            if (measuredText.getTextOffset() >= fullTextLength || !canOverflow || !this.isConsumeSpaceOnOverflow()) {
                this.setPrepareHeight(elementTextHeight);
            } else {
                this.setPrepareHeight(this.getHeight() + availableStretchHeight);
            }
        } else {
            this.setPrepareHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(measuredText.getTextOffset());
        this.setCutParagraphToContinueInOverflow(canOverflow && measuredText.isParagraphCut());
        this.setLineBreakOffsets(measuredText.getLineBreakOffsets());
        this.setTextTruncateSuffix(measuredText.getTextSuffix());
        this.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        this.setLeadingOffset(measuredText.getLeadingOffset());
    }

    private static float scaleFontSize(float fontSize, float factor, float scaleFontStepLimit) {
        float newFontSize = (float)((int)(100.0f * ((float)Math.round(factor * fontSize / scaleFontStepLimit) * scaleFontStepLimit))) / 100.0f;
        newFontSize = newFontSize < scaleFontStepLimit ? scaleFontStepLimit : newFontSize;
        return newFontSize;
    }

    private static float alterFontSizes(JRStyledText styledText, float factor, float scaleFontStepLimit) {
        float fontSizeMaxDiff = 0.0f;
        if (styledText != null && styledText.length() != 0) {
            fontSizeMaxDiff = JRFillTextElement.alterFontSize(styledText.getGlobalAttributes(), factor, scaleFontStepLimit, fontSizeMaxDiff);
            List<JRStyledText.Run> runs = styledText.getRuns();
            for (JRStyledText.Run run : runs) {
                fontSizeMaxDiff = JRFillTextElement.alterFontSize(run.attributes, factor, scaleFontStepLimit, fontSizeMaxDiff);
            }
            styledText.append("");
        }
        return fontSizeMaxDiff;
    }

    private static float alterFontSize(Map<AttributedCharacterIterator.Attribute, Object> attributes, float factor, float scaleFontStepLimit, float fontSizeMaxDiff) {
        Float originalFontSize = (Float)attributes.get(JRTextAttribute.FONT_SIZE);
        if (originalFontSize == null && (originalFontSize = (Float)attributes.get(TextAttribute.SIZE)) != null) {
            attributes.put(JRTextAttribute.FONT_SIZE, originalFontSize);
        }
        if (originalFontSize != null) {
            Float newFontSize = Float.valueOf(JRFillTextElement.scaleFontSize(originalFontSize.floatValue(), factor, scaleFontStepLimit));
            Float oldFontSize = (Float)attributes.get(TextAttribute.SIZE);
            fontSizeMaxDiff = Math.max(Math.abs(newFontSize.floatValue() - oldFontSize.floatValue()), fontSizeMaxDiff);
            attributes.put(TextAttribute.SIZE, newFontSize);
        }
        return fontSizeMaxDiff;
    }

    protected boolean isConsumeSpaceOnOverflow() {
        String consumeSpaceOnOverflowProp;
        if (this.defaultConsumeSpaceOnOverflow == null) {
            this.defaultConsumeSpaceOnOverflow = this.filler.getPropertiesUtil().getBooleanProperty(PROPERTY_CONSUME_SPACE_ON_OVERFLOW, true, this.parent, this.filler.getMainDataset());
        }
        boolean consumeSpaceOnOverflow = this.defaultConsumeSpaceOnOverflow;
        if (this.dynamicConsumeSpaceOnOverflow && (consumeSpaceOnOverflowProp = this.getDynamicProperties().getProperty(PROPERTY_CONSUME_SPACE_ON_OVERFLOW)) != null) {
            consumeSpaceOnOverflow = JRPropertiesUtil.asBoolean(consumeSpaceOnOverflowProp);
        }
        return consumeSpaceOnOverflow;
    }

    protected abstract boolean canOverflow();

    protected abstract boolean scaleFontToFit();

    @Override
    public String getFontName() {
        return this.getStyleResolver().getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.providerStyle == null || this.providerStyle.getOwnFontName() == null ? ((JRFont)((Object)this.parent)).getOwnFontName() : this.providerStyle.getOwnFontName();
    }

    @Override
    public void setFontName(String fontName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBold() {
        return this.getStyleResolver().isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.providerStyle == null || this.providerStyle.isOwnBold() == null ? ((JRFont)((Object)this.parent)).isOwnBold() : this.providerStyle.isOwnBold();
    }

    @Override
    public void setBold(Boolean isBold) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isItalic() {
        return this.getStyleResolver().isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.providerStyle == null || this.providerStyle.isOwnItalic() == null ? ((JRFont)((Object)this.parent)).isOwnItalic() : this.providerStyle.isOwnItalic();
    }

    @Override
    public void setItalic(Boolean isItalic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnderline() {
        return this.getStyleResolver().isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.providerStyle == null || this.providerStyle.isOwnUnderline() == null ? ((JRFont)((Object)this.parent)).isOwnUnderline() : this.providerStyle.isOwnUnderline();
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStrikeThrough() {
        return this.getStyleResolver().isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.providerStyle == null || this.providerStyle.isOwnStrikeThrough() == null ? ((JRFont)((Object)this.parent)).isOwnStrikeThrough() : this.providerStyle.isOwnStrikeThrough();
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFontsize() {
        return this.getStyleResolver().getFontsize(this);
    }

    @Override
    public Float getOwnFontsize() {
        return this.providerStyle == null || this.providerStyle.getOwnFontsize() == null ? ((JRFont)((Object)this.parent)).getOwnFontsize() : this.providerStyle.getOwnFontsize();
    }

    @Override
    public void setFontSize(Float size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPdfFontName() {
        return this.getStyleResolver().getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.providerStyle == null || this.providerStyle.getOwnPdfFontName() == null ? ((JRFont)((Object)this.parent)).getOwnPdfFontName() : this.providerStyle.getOwnPdfFontName();
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPdfEncoding() {
        return this.getStyleResolver().getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.providerStyle == null || this.providerStyle.getOwnPdfEncoding() == null ? ((JRFont)((Object)this.parent)).getOwnPdfEncoding() : this.providerStyle.getOwnPdfEncoding();
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPdfEmbedded() {
        return this.getStyleResolver().isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.providerStyle == null || this.providerStyle.isOwnPdfEmbedded() == null ? ((JRFont)((Object)this.parent)).isOwnPdfEmbedded() : this.providerStyle.isOwnPdfEmbedded();
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.createTextMeasurer();
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.createTextMeasurer();
    }

    protected String processMarkupText(String text) {
        String markup;
        if ((text = JRStringUtil.replaceCRwithLF(text)) != null && !"none".equals(markup = this.getMarkup()) && !"styled".equals(markup)) {
            text = this.getMarkupProcessor(markup).convert(text);
        }
        return text;
    }

    protected MarkupProcessor getMarkupProcessor(String markup) {
        MarkupProcessor markupProcessor = markupProcessors.get(markup);
        if (markupProcessor == null) {
            String factoryClass = this.filler.getPropertiesUtil().getProperty("net.sf.jasperreports.markup.processor.factory." + markup);
            if (factoryClass == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MISSING_MARKUP_PROCESSOR_FACTORY, markup);
            }
            MarkupProcessorFactory factory = null;
            try {
                factory = markupProcessorFactoryCache.getCachedInstance(factoryClass);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            markupProcessor = factory.createMarkupProcessor();
            markupProcessors.put(markup, markupProcessor);
        }
        return markupProcessor;
    }

    protected void setPrintText(JRPrintText printText) {
        boolean keepAllText;
        int startIndex = this.getTextStart();
        int endIndex = this.getTextEnd();
        JRStyledText fullStyledText = this.getStyledText();
        String fullText = fullStyledText.getText();
        boolean bl = keepAllText = !this.canOverflow() && this.keepFullText();
        if (keepAllText) {
            if (startIndex != 0) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_START_INDEX, (Object[])null);
            }
            if ("none".equals(this.getMarkup())) {
                this.setPrintText(printText, fullText);
            } else {
                String styledText = this.filler.getStyledTextParser().write(fullStyledText);
                this.setPrintText(printText, styledText);
            }
            if (endIndex < fullText.length()) {
                printText.setTextTruncateIndex(endIndex);
            }
        } else if ("none".equals(this.getMarkup())) {
            this.setPrintText(printText, fullText.substring(startIndex, endIndex));
        } else {
            if (startIndex > 0) {
                int i;
                StyledTextListInfo[] cutListStack = null;
                List<JRStyledText.Run> runs = fullStyledText.getRuns();
                for (i = runs.size() - 1; i >= 0; --i) {
                    StyledTextListItemInfo listItem;
                    JRStyledText.Run run = runs.get(i);
                    if (run.startIndex > startIndex || startIndex >= run.endIndex) continue;
                    StyledTextListInfo[] listStack = (StyledTextListInfo[])run.attributes.get(JRTextAttribute.HTML_LIST);
                    if (listStack != null) {
                        cutListStack = listStack;
                    }
                    if ((listItem = (StyledTextListItemInfo)run.attributes.get(JRTextAttribute.HTML_LIST_ITEM)) == null) continue;
                    listItem.setNoBullet(run.startIndex < startIndex);
                }
                if (cutListStack != null && cutListStack.length > 0) {
                    for (i = cutListStack.length - 1; i > 0; --i) {
                        void list = cutListStack[i];
                        if (list.hasParentLi()) continue;
                        StyledTextListInfo parentList = cutListStack[i - 1];
                        parentList.setCutStart(parentList.getCutStart() + 1);
                    }
                }
            }
            String styledText = this.filler.getStyledTextParser().write(fullStyledText, startIndex, endIndex);
            this.setPrintText(printText, styledText);
        }
        printText.setTextTruncateSuffix(this.getTextTruncateSuffix());
        printText.setLineBreakOffsets(this.getLineBreakOffsets());
        if (this.isCutParagraphOverflow && this.getParagraph().getFirstLineIndent() != 0) {
            printText.getPropertiesMap().setProperty("net.sf.jasperreports.awt.indent.first.line", Boolean.FALSE.toString());
        }
        if (fullText != null && endIndex < fullText.length() && HorizontalTextAlignEnum.JUSTIFIED == this.getHorizontalTextAlign()) {
            printText.getPropertiesMap().setProperty("net.sf.jasperreports.awt.justify.last.line", Boolean.TRUE.toString());
        }
    }

    protected boolean keepFullText() {
        String keepFullTextProp;
        if (this.defaultKeepFullText == null) {
            this.defaultKeepFullText = this.filler.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.print.keep.full.text", false, this.parent, this.filler.getMainDataset());
        }
        boolean keepFullText = this.defaultKeepFullText;
        if (this.dynamicKeepFullText && (keepFullTextProp = this.getDynamicProperties().getProperty("net.sf.jasperreports.print.keep.full.text")) != null) {
            keepFullText = JRPropertiesUtil.asBoolean(keepFullTextProp);
        }
        return keepFullText;
    }

    protected float scaleFontStepLimit() {
        String scaleFontStepLimitProp;
        if (this.defaultScaleFontStepLimit == null) {
            this.defaultScaleFontStepLimit = Float.valueOf(this.filler.getPropertiesUtil().getFloatProperty(PROPERTY_SCALE_FONT_STEP_LIMIT, 0.5f, this.parent, this.filler.getMainDataset()));
        }
        float scaleFontStepLimit = this.defaultScaleFontStepLimit.floatValue();
        if (this.dynamicScaleFontStepLimit && (scaleFontStepLimitProp = this.getDynamicProperties().getProperty(PROPERTY_SCALE_FONT_STEP_LIMIT)) != null) {
            scaleFontStepLimit = JRPropertiesUtil.asFloat(scaleFontStepLimitProp);
        }
        return scaleFontStepLimit;
    }

    protected void setPrintText(JRPrintText printText, String text) {
        printText.setText(text);
    }

    protected String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    protected void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
    }

    private static class FillStyleObjects {
        private final JRLineBox lineBox;
        private final JRParagraph paragraph;

        public FillStyleObjects(JRLineBox lineBox, JRParagraph paragraph) {
            this.lineBox = lineBox;
            this.paragraph = paragraph;
        }
    }
}

