/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support.breadcrumbs;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.VertexRefAdapter;
import org.opennms.features.topology.api.support.breadcrumbs.BreadcrumbCriteria;
import org.opennms.features.topology.api.support.breadcrumbs.ClickListener;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.VertexRef;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="breadcrumb")
public class Breadcrumb
implements ClickListener {
    @XmlElement(name="source-vertex")
    @XmlElementWrapper(name="source-vertices")
    @XmlJavaTypeAdapter(value=VertexRefAdapter.class)
    private List<VertexRef> sourceVertices = Lists.newArrayList();
    @XmlElement(name="target-namespace")
    private String targetNamespace;

    protected Breadcrumb() {
    }

    public Breadcrumb(String namespace, VertexRef vertex) {
        this.targetNamespace = namespace;
        this.sourceVertices.add(vertex);
    }

    public Breadcrumb(String targetNamespace, List<VertexRef> vertices) {
        this.targetNamespace = targetNamespace;
        this.sourceVertices = Lists.newArrayList(vertices);
    }

    public Breadcrumb(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Breadcrumb) {
            Breadcrumb other = (Breadcrumb)obj;
            boolean equals = Objects.equals(this.targetNamespace, other.targetNamespace) && Objects.equals(this.sourceVertices, other.sourceVertices);
            return equals;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.targetNamespace, this.sourceVertices);
    }

    @Override
    public void clicked(GraphContainer graphContainer) {
        BreadcrumbCriteria criteria = Criteria.getSingleCriteriaForGraphContainer(graphContainer, BreadcrumbCriteria.class, false);
        if (criteria != null) {
            criteria.handleClick(this, graphContainer);
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public List<VertexRef> getSourceVertices() {
        return this.sourceVertices.stream().sorted(Comparator.comparing(Ref::getLabel)).collect(Collectors.toList());
    }
}

