/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import org.opennms.features.topology.api.IViewContribution;
import org.opennms.features.topology.api.WidgetContext;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.EventProxyAware;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextAware;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class BlueprintIViewContribution
implements IViewContribution {
    private final BlueprintContainer m_container;
    private final String m_beanId;
    private String m_title;

    public BlueprintIViewContribution(BlueprintContainer container, String beanId) {
        this.m_container = container;
        this.m_beanId = beanId;
    }

    @Override
    public Component getView(VaadinApplicationContext vaadinApplicationContext, WidgetContext widgetContext) {
        Component component = (Component)this.m_container.getComponentInstance(this.m_beanId);
        BundleContext bundleContext = (BundleContext)this.m_container.getComponentInstance("blueprintBundleContext");
        EventProxy eventProxy = vaadinApplicationContext.getEventProxy(bundleContext);
        eventProxy.addPossibleEventConsumer((Object)component);
        this.injectEventProxy(component, eventProxy);
        this.injectVaadinApplicationContext(component, vaadinApplicationContext);
        return component;
    }

    private void injectEventProxy(Component component, EventProxy eventProxy) {
        if (component instanceof EventProxyAware) {
            ((EventProxyAware)component).setEventProxy(eventProxy);
        }
    }

    private void injectVaadinApplicationContext(Component component, VaadinApplicationContext vaadinApplicationContext) {
        if (component instanceof VaadinApplicationContextAware) {
            ((VaadinApplicationContextAware)component).setVaadinApplicationContext(vaadinApplicationContext);
        }
    }

    @Override
    public Resource getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String toString() {
        return "BlueprintIViewContribution [container=" + this.m_container + ", beanId=" + this.m_beanId + ", title=" + this.m_title + "]";
    }
}

