/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.records;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.time.Instant;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Record;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Type;

public class Collector
extends Record {
    public Action action;
    public Long sequence;
    public String adminId;
    public String hash;
    public List<InetAddress> routers;
    public Instant timestamp;

    public Collector() {
        super(Type.COLLECTOR);
    }

    @Override
    protected String[] fields() {
        return new String[]{this.action.value, Collector.nullSafeStr(this.sequence), this.adminId, this.hash, this.routers != null ? Joiner.on((char)',').join(Iterables.transform(this.routers, InetAddressUtils::str)) : "", this.routers != null ? Integer.toString(this.routers.size()) : "0", Record.formatTimestamp(this.timestamp)};
    }

    public static enum Action {
        STARTED("started"),
        CHANGE("change"),
        HEARTBEAT("heartbeat"),
        STOPPED("stopped");

        public final String value;

        private Action(String value) {
            this.value = value;
        }
    }
}

