/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.net.InetAddress;
import java.util.Optional;

public class AmiAgentConfig {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RETRIES = 1;
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_USERNAME = "opennms";
    public static final int DEFAULT_PORT = 5038;
    public static final int DEFAULT_TLS_PORT = 5039;
    public static final boolean DEFAULT_USE_TLS = false;
    private InetAddress m_address;
    private Integer m_timeout;
    private Integer m_retries;
    private String m_username;
    private String m_password;
    private Integer m_port;
    private Boolean m_useTls;
    String user = "";
    String pass = "";
    String matchType = "all";

    public AmiAgentConfig() {
        this.setDefaults();
    }

    public AmiAgentConfig(InetAddress agentAddress) {
        this.m_address = agentAddress;
        this.setDefaults();
    }

    private void setDefaults() {
        this.m_timeout = 3000;
        this.m_retries = 1;
        this.m_port = 5038;
        this.m_useTls = false;
        this.m_username = DEFAULT_USERNAME;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("AgentConfig[");
        buff.append("Address: " + String.valueOf(this.m_address));
        buff.append(", Port: " + this.m_port);
        buff.append(", TLS: " + this.m_useTls);
        buff.append(", Username: " + String.valueOf(this.m_username));
        buff.append(", Password: " + String.valueOf(this.m_password));
        buff.append(", Timeout: " + this.m_timeout);
        buff.append(", Retries: " + this.m_retries);
        buff.append("]");
        return buff.toString();
    }

    public Optional<InetAddress> getAddress() {
        return Optional.ofNullable(this.m_address);
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public Optional<Integer> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.m_retries);
    }

    public void setRetries(Integer retries) {
        this.m_retries = retries;
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.m_username);
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.m_port);
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public Optional<Boolean> getUseTls() {
        return Optional.ofNullable(this.m_useTls);
    }

    public void setUseTls(Boolean useTls) {
        this.m_useTls = useTls;
    }
}

