/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.collectd.Parameter;

@XmlRootElement(name="service")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Service
implements Serializable {
    private static final long serialVersionUID = -8462778654204715732L;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="interval")
    private Long m_interval;
    @XmlAttribute(name="user-defined")
    private String m_userDefined;
    @XmlAttribute(name="status")
    private String m_status;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Long getInterval() {
        return this.m_interval == null ? 0L : this.m_interval;
    }

    public void setInterval(Long interval) {
        this.m_interval = interval;
    }

    public String getUserDefined() {
        return this.m_userDefined;
    }

    public void setUserDefined(String userDefined) {
        this.m_userDefined = userDefined;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public List<Parameter> getParameters() {
        if (this.m_parameters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        this.m_parameters = new ArrayList<Parameter>(parameters);
    }

    public void addParameter(Parameter parameter) throws IndexOutOfBoundsException {
        this.m_parameters.add(parameter);
    }

    public void addParameter(String key, String value) {
        this.m_parameters.add(new Parameter(key, value));
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public String getParameter(String key) {
        for (Parameter parm : this.m_parameters) {
            if (!key.equals(parm.getKey())) continue;
            return parm.getValue();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_interval == null ? 0 : this.m_interval.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_parameters == null ? 0 : this.m_parameters.hashCode());
        result = 31 * result + (this.m_status == null ? 0 : this.m_status.hashCode());
        result = 31 * result + (this.m_userDefined == null ? 0 : this.m_userDefined.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (this.m_interval == null ? other.m_interval != null : !this.m_interval.equals(other.m_interval)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_parameters == null ? other.m_parameters != null : !this.m_parameters.equals(other.m_parameters)) {
            return false;
        }
        if (this.m_status == null ? other.m_status != null : !this.m_status.equals(other.m_status)) {
            return false;
        }
        return !(this.m_userDefined == null ? other.m_userDefined != null : !this.m_userDefined.equals(other.m_userDefined));
    }

    public String toString() {
        return "Service [name=" + this.m_name + ", interval=" + this.m_interval + ", userDefined=" + this.m_userDefined + ", status=" + this.m_status + ", parameters=" + String.valueOf(this.m_parameters) + "]";
    }
}

