/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.BmpAdapterTools;
import org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpPeerStatusAdapter
extends AbstractAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BmpPeerStatusAdapter.class);
    private final InterfaceToNodeCache interfaceToNodeCache;
    private final EventForwarder eventForwarder;
    private final NodeDao nodeDao;
    private String metaDataNodeLookup;
    private ContextKey contextKey;

    public BmpPeerStatusAdapter(AdapterDefinition adapterConfig, InterfaceToNodeCache interfaceToNodeCache, EventForwarder eventForwarder, MetricRegistry metricRegistry, NodeDao nodeDao) {
        super(adapterConfig, metricRegistry);
        this.interfaceToNodeCache = Objects.requireNonNull(interfaceToNodeCache);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.nodeDao = nodeDao;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(TelemetryMessageLogEntry messageLogEntry, TelemetryMessageLog messageLog) {
        Transport.PeerDownPacket peerDown;
        Transport.Message message;
        LOG.trace("Parsing packet: {}", (Object)messageLogEntry);
        try {
            message = Transport.Message.parseFrom((byte[])messageLogEntry.getByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Invalid message", (Throwable)e);
            return;
        }
        Transport.PeerUpPacket peerUp = message.hasPeerUp() ? message.getPeerUp() : null;
        Transport.PeerDownPacket peerDownPacket = peerDown = message.hasPeerDown() ? message.getPeerDown() : null;
        if (peerUp == null && peerDown == null) {
            return;
        }
        InetAddress exporterAddress = InetAddressUtils.getInetAddress((String)messageLog.getSourceAddress());
        Optional<Integer> exporterNodeId = this.interfaceToNodeCache.getFirstNodeId(messageLog.getLocation(), exporterAddress);
        if (!exporterNodeId.isPresent()) {
            if (!message.hasBgpId()) {
                LOG.info("Unable to find node for exporter address: {} at location: {}. Message has no bgpId. Message will be ignored.", (Object)exporterAddress, (Object)messageLog.getLocation());
                return;
            }
            String bgpId = InetAddressUtils.toIpAddrString((InetAddress)BmpAdapterTools.address(message.getBgpId()));
            LOG.info("Unable to find node for exporter address: {} at location: {}. Trying to lookup by bgpId: {}", new Object[]{exporterAddress, messageLog.getLocation(), bgpId});
            List nodes = this.nodeDao.findNodeWithMetaData(this.contextKey.getContext(), this.contextKey.getKey(), bgpId);
            if (nodes.size() <= 0) {
                LOG.warn("Unable to find node for bgpId: {}. Message will be ignored.", (Object)bgpId);
                return;
            }
            Integer effectiveId = ((OnmsNode)nodes.get(0)).getId();
            if (nodes.size() > 1) {
                LOG.warn("More that one node match bgpId: {}. Using the first: {}", (Object)bgpId, (Object)effectiveId);
            }
            exporterNodeId = Optional.of(effectiveId);
        }
        String uei = peerUp != null ? "uei.opennms.org/bmp/peerUp" : "uei.opennms.org/bmp/peerDown";
        Transport.Peer peer = peerUp != null ? peerUp.getPeer() : peerDown.getPeer();
        Instant timestamp = Instant.ofEpochSecond(peer.getTimestamp().getSeconds(), peer.getTimestamp().getNanos());
        EventBuilder event = new EventBuilder(uei, "telemetryd:" + this.adapterConfig.getFullName(), Date.from(timestamp));
        event.setNodeid((long)((Integer)exporterNodeId.get()).intValue());
        event.setInterface(exporterAddress);
        event.addParam("distinguisher", peer.getDistinguisher());
        event.addParam("address", InetAddressUtils.str((InetAddress)BmpAdapterTools.address(peer.getAddress())));
        event.addParam("as", Long.toString(peer.getAs()));
        event.addParam("id", InetAddressUtils.str((InetAddress)BmpAdapterTools.address(peer.getId())));
        if (peerDown != null) {
            switch (peerDown.getReasonCase()) {
                case LOCAL_BGP_NOTIFICATION: {
                    event.addParam("error", "Local disconnect: " + String.valueOf(peerDown.getLocalBgpNotification()));
                    break;
                }
                case LOCAL_NO_NOTIFICATION: {
                    event.addParam("error", "Local disconnect without notification: code = " + peerDown.getLocalNoNotification());
                    break;
                }
                case REMOTE_BGP_NOTIFICATION: {
                    event.addParam("error", "Remote disconnect: " + String.valueOf(peerDown.getRemoteBgpNotification()));
                    break;
                }
                case REMOTE_NO_NOTIFICATION: {
                    event.addParam("error", "Remote disconnect without notification");
                    break;
                }
            }
        }
        this.eventForwarder.sendNow(event.getEvent());
    }

    public String getMetaDataNodeLookup() {
        return this.metaDataNodeLookup;
    }

    public void setMetaDataNodeLookup(String metaDataNodeLookup) {
        this.metaDataNodeLookup = metaDataNodeLookup;
        this.contextKey = !Strings.isNullOrEmpty((String)this.metaDataNodeLookup) ? new ContextKey(metaDataNodeLookup) : null;
    }
}

