/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.net.InetAddress;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.MacCloud;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.TopologyShared;
import org.opennms.netmgt.model.OnmsNode;

public interface Topology {
    public String printTopology();

    public static String getPortTextString(SnmpInterfaceTopologyEntity snmpiface) {
        StringBuilder port = new StringBuilder();
        port.append(snmpiface.getIfName());
        if (!"".equals(snmpiface.getIfAlias())) {
            port.append("(");
            port.append(snmpiface.getIfAlias());
            port.append(")");
        }
        if (snmpiface.getIfSpeed() != null && snmpiface.getIfSpeed() > 0L) {
            port.append("(");
            port.append(InetAddressUtils.getHumanReadableIfSpeed((long)snmpiface.getIfSpeed()));
            port.append(")");
        }
        port.append("(ifIndex:");
        port.append(snmpiface.getIfIndex());
        port.append(")");
        return port.toString();
    }

    public static String getPortTextString(String label, Integer ifindex, String address, SnmpInterfaceTopologyEntity snmpiface) {
        if (snmpiface == null) {
            return Topology.getPortTextString(label, ifindex, address);
        }
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append(label);
        tooltipText.append(" ");
        tooltipText.append(Topology.getPortTextString(snmpiface));
        if (address != null) {
            tooltipText.append("(");
            tooltipText.append(address);
            tooltipText.append(")");
        }
        return tooltipText.toString();
    }

    public static String getPortTextString(String label, Integer ifindex, String address) {
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append(label);
        tooltipText.append(" ");
        if (ifindex != null) {
            tooltipText.append("(ifIndex:");
            tooltipText.append(ifindex);
            tooltipText.append(")");
        }
        if (address != null) {
            tooltipText.append("(");
            tooltipText.append(address);
            tooltipText.append(")");
        }
        return tooltipText.toString();
    }

    public static String getSharedSegmentId(TopologyShared designated) {
        return "s:" + Topology.getId(designated);
    }

    public static String getMacsCloudId(TopologyShared designated) {
        return "m:" + Topology.getId(designated);
    }

    public static String getMacsIpLabel() {
        return "Macs/ip addresses on Segment without node";
    }

    public static String getSharedSegmentLabel() {
        return "Segment";
    }

    public static String getAddress(InetAddress address) {
        return InetAddressUtils.str((InetAddress)address);
    }

    public static String getAddress(IpInterfaceTopologyEntity ip) {
        if (ip == null) {
            return null;
        }
        return Topology.getAddress(ip.getIpAddress());
    }

    public static String getAddress(MacPort port) {
        return port.getPortMacInfo();
    }

    public static String getAddress(MacCloud cloud) {
        return cloud.getMacsInfo();
    }

    public static String getAddress(BridgePort bp) {
        return String.format("bridge port %d vlan %d", bp.getBridgePort(), bp.getVlan());
    }

    public static String getAddress(CdpLinkTopologyEntity cdplink) {
        return cdplink.getCdpCacheAddress();
    }

    public static String getRemoteAddress(LldpLinkTopologyEntity lldplink) {
        return String.format("%s type %s", lldplink.getLldpRemPortId(), lldplink.getLldpRemPortIdSubType().name());
    }

    public static String getRemoteAddress(OspfLinkTopologyEntity ospflink) {
        return InetAddressUtils.str((InetAddress)ospflink.getOspfRemIpAddr());
    }

    public static String getAddress(OspfLinkTopologyEntity ospflink) {
        return String.format("%s mask %s", InetAddressUtils.str((InetAddress)ospflink.getOspfIpAddr()), InetAddressUtils.str((InetAddress)ospflink.getOspfIpMask()));
    }

    public static String getRemoteAddress(IsIsLinkTopologyEntity isislink) {
        return isislink.getIsisISAdjNeighSNPAAddress();
    }

    public static String getAddress(MacCloud cloud, List<MacPort> ports) {
        StringBuilder ip = new StringBuilder();
        if (cloud != null) {
            ip.append(cloud.getMacsInfo());
        }
        for (MacPort port : ports) {
            ip.append(port.getPortMacInfo());
        }
        return ip.toString();
    }

    public static String getMacsCloudIpTextString(TopologyShared shared, List<MacPort> ports) {
        return "shared addresses: (" + Topology.getAddress(shared.getCloud(), ports) + ")(" + Topology.getNodeStatus(OnmsNode.NodeType.UNKNOWN) + "/Not an OpenNMS Node)";
    }

    public static String getNodeTextString(NodeTopologyEntity node, IpInterfaceTopologyEntity primary) {
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append(node.getLabel());
        tooltipText.append(": ");
        if (primary != null) {
            tooltipText.append("(");
            tooltipText.append(InetAddressUtils.str((InetAddress)primary.getIpAddress()));
            tooltipText.append(")");
        }
        tooltipText.append("(");
        tooltipText.append(Topology.getNodeStatus(node.getType()));
        if (primary != null) {
            tooltipText.append("/");
            tooltipText.append(Topology.getIsManaged(primary.isManaged()));
        }
        tooltipText.append(")");
        if (node.getLocation() != null && node.getLocation().trim().length() > 0) {
            tooltipText.append(node.getLocation());
        }
        return tooltipText.toString();
    }

    public static String getSharedSegmentTextString(TopologyShared segment) {
        return String.format("'Shared Segment': %s", segment.getUpPort().printTopology());
    }

    public static String getIsManaged(boolean isManaged) {
        if (isManaged) {
            return "Managed";
        }
        return "Unmanaged";
    }

    public static String getDefaultIconKey() {
        return "linkd.system";
    }

    public static String getCloudIconKey() {
        return "cloud";
    }

    public static String getIconKey(NodeTopologyEntity node) {
        if (node.getSysObjectId() == null) {
            return "linkd.system";
        }
        if (node.getSysObjectId().startsWith(".")) {
            return "linkd.system.snmp" + node.getSysObjectId();
        }
        return "linkd.system.snmp." + node.getSysObjectId();
    }

    public static String getNodeStatus(OnmsNode.NodeType nodeType) {
        if (nodeType == null) {
            return "undefined";
        }
        return switch (nodeType) {
            case OnmsNode.NodeType.ACTIVE -> "Active";
            case OnmsNode.NodeType.UNKNOWN -> "Unknown";
            case OnmsNode.NodeType.DELETED -> "Deleted";
            default -> "undefined";
        };
    }

    public static String getDefaultEdgeId(int sourceId, int targetId) {
        return Math.min(sourceId, targetId) + "|" + Math.max(sourceId, targetId);
    }

    public static String getId(TopologyShared segment) {
        return Topology.getId(segment.getUpPort());
    }

    public static String getId(MacCloud macCloud) {
        return macCloud.getMacs().toString();
    }

    public static String getId(MacPort macPort) {
        if (macPort.getNodeId() == null) {
            return macPort.getMacPortMap().keySet().toString();
        }
        return Integer.toString(macPort.getNodeId());
    }

    public static String getId(BridgePort bp) {
        return bp.getNodeId() + ":" + bp.getBridgePort();
    }

    public static String getEdgeId(BridgePort bp, MacPort macport) {
        return Topology.getId(bp) + "|" + Topology.getId(macport);
    }

    public static String getEdgeId(BridgePort sourcebp, BridgePort targetbp) {
        if (sourcebp.getNodeId() < targetbp.getNodeId()) {
            return Topology.getId(sourcebp) + "|" + Topology.getId(targetbp);
        }
        return Topology.getId(targetbp) + "|" + Topology.getId(sourcebp);
    }

    public static String getEdgeId(String id, MacPort macport) {
        return id + "|" + Topology.getId(macport);
    }

    public static String getEdgeId(String id, BridgePort bp) {
        return id + "|" + bp.getNodeId() + ":" + bp.getBridgePort();
    }

    public static String getDefaultEdgeId(String id1, String id2) {
        return id1 + "|" + id2;
    }

    public static String getPortId(String id) {
        return "p:" + id;
    }
}

