/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.datacollection.graphs.PrefabGraph;
import org.opennms.integration.api.xml.GraphPropertiesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathGraphPropertiesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathGraphPropertiesLoader.class);
    private final ClassLoader classLoader;
    private final String subFolder;
    private final String[] fileNames;

    public ClassPathGraphPropertiesLoader(Class<?> clazz, String ... fileNames) {
        this(clazz, "graphs", fileNames);
    }

    private ClassPathGraphPropertiesLoader(Class<?> clazz, String subFolder, String ... fileNames) {
        this.classLoader = Objects.requireNonNull(clazz).getClassLoader();
        this.subFolder = Objects.requireNonNull(subFolder);
        this.fileNames = fileNames;
    }

    public List<PrefabGraph> getGraphProperties() {
        ArrayList<PrefabGraph> allObjects = new ArrayList<PrefabGraph>();
        for (String fileName : this.fileNames) {
            try (InputStream is = this.classLoader.getResourceAsStream(this.subFolder + File.separator + fileName);){
                if (is == null) continue;
                List<PrefabGraph> graphs = GraphPropertiesParser.loadPreFabGraphsFromInputStream(is);
                allObjects.addAll(graphs);
            }
            catch (IOException e) {
                LOG.warn("Failed to load {}. Skipping.", (Object)fileName, (Object)e);
            }
        }
        return allObjects;
    }
}

