/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.ImmutableCollections;
import org.opennms.core.utils.MutableCollections;
import org.opennms.netmgt.events.api.model.ICorrelation;

public final class ImmutableCorrelation
implements ICorrelation {
    private final String state;
    private final String path;
    private final List<String> cueiList;
    private final String cmin;
    private final String cmax;
    private final String ctime;

    private ImmutableCorrelation(Builder builder) {
        this.state = builder.state;
        this.path = builder.path;
        this.cueiList = ImmutableCollections.newListOfImmutableType(builder.cueiList);
        this.cmin = builder.cmin;
        this.cmax = builder.cmax;
        this.ctime = builder.ctime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(ICorrelation correlation) {
        return new Builder(correlation);
    }

    public static ICorrelation immutableCopy(ICorrelation correlation) {
        if (correlation == null || correlation instanceof ImmutableCorrelation) {
            return correlation;
        }
        return ImmutableCorrelation.newBuilderFrom(correlation).build();
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<String> getCueiCollection() {
        return this.cueiList;
    }

    @Override
    public String getCmin() {
        return this.cmin;
    }

    @Override
    public String getCmax() {
        return this.cmax;
    }

    @Override
    public String getCtime() {
        return this.ctime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCorrelation that = (ImmutableCorrelation)o;
        return Objects.equals(this.state, that.state) && Objects.equals(this.path, that.path) && Objects.equals(this.cueiList, that.cueiList) && Objects.equals(this.cmin, that.cmin) && Objects.equals(this.cmax, that.cmax) && Objects.equals(this.ctime, that.ctime);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.path, this.cueiList, this.cmin, this.cmax, this.ctime);
    }

    public String toString() {
        return "ImmutableCorrelation{state='" + this.state + "', path='" + this.path + "', cueiList=" + String.valueOf(this.cueiList) + ", cmin='" + this.cmin + "', cmax='" + this.cmax + "', ctime='" + this.ctime + "'}";
    }

    public static final class Builder {
        private String state;
        private String path;
        private List<String> cueiList;
        private String cmin;
        private String cmax;
        private String ctime;

        private Builder() {
        }

        public Builder(ICorrelation correlation) {
            this.state = correlation.getState();
            this.path = correlation.getPath();
            this.cueiList = MutableCollections.copyListFromNullable(correlation.getCueiCollection());
            this.cmin = correlation.getCmin();
            this.cmax = correlation.getCmax();
            this.ctime = correlation.getCtime();
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setCueiList(List<String> cueiList) {
            this.cueiList = cueiList;
            return this;
        }

        public Builder setCmin(String cmin) {
            this.cmin = cmin;
            return this;
        }

        public Builder setCmax(String cmax) {
            this.cmax = cmax;
            return this;
        }

        public Builder setCtime(String ctime) {
            this.ctime = ctime;
            return this;
        }

        public ImmutableCorrelation build() {
            return new ImmutableCorrelation(this);
        }
    }
}

