/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search.support;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opennms.newts.cassandra.ContextConfigurations;
import org.opennms.newts.cassandra.search.support.StatementGenerator;

public class StatementUtils {
    public static List<Statement> getStatements(ContextConfigurations contextConfigurations, int maxBatchSize, Set<StatementGenerator> generators) {
        ArrayList statementsToExecute = Lists.newArrayList();
        HashMap statementsByKey = Maps.newHashMap();
        for (StatementGenerator generator : generators) {
            BatchableStatement statement = (BatchableStatement)generator.toStatement().setConsistencyLevel(contextConfigurations.getWriteConsistency(generator.getContext()));
            String key = generator.getKey();
            if (key == null) {
                statementsToExecute.add(statement);
                continue;
            }
            List statementsForKey = (List)statementsByKey.get(key);
            if (statementsForKey == null) {
                statementsForKey = Lists.newArrayList();
                statementsByKey.put(key, statementsForKey);
            }
            statementsForKey.add(statement);
        }
        for (List statementsForKey : statementsByKey.values()) {
            for (List partition : Lists.partition((List)statementsForKey, (int)maxBatchSize)) {
                BatchStatementBuilder builder = BatchStatement.builder((BatchType)DefaultBatchType.UNLOGGED);
                for (BatchableStatement statement : partition) {
                    builder.addStatement(statement);
                }
                statementsToExecute.add(builder.build());
            }
        }
        return statementsToExecute;
    }
}

