/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.common;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.cache.NodeInfo;
import org.opennms.netmgt.telemetry.protocols.cache.NodeInfoCache;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractScriptedCollectionAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.List;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.Value;

public class NetflowTelemetryAdapter
extends AbstractScriptedCollectionAdapter {
    private final Timer scriptEvaluationTimer;
    private final Meter metricsCollected;
    private final Meter rawValuesProcessed;
    private InterfaceToNodeCache interfaceToNodeCache;
    private CollectionAgentFactory collectionAgentFactory;
    private ContextKey contextKey;
    private String metaDataNodeLookup;
    private final NodeInfoCache nodeInfoCache;

    protected NetflowTelemetryAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, NodeInfoCache nodeInfoCache) {
        super(adapterConfig, metricRegistry);
        this.nodeInfoCache = nodeInfoCache;
        this.scriptEvaluationTimer = metricRegistry.timer(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "scriptEvaluation"}));
        this.rawValuesProcessed = metricRegistry.meter(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "rawValuesProcessed"}));
        this.metricsCollected = metricRegistry.meter(MetricRegistry.name((String)"adapters", (String[])new String[]{adapterConfig.getFullName(), "metricsCollected"}));
    }

    public Stream<CollectionSetWithAgent> handleCollectionMessage(TelemetryMessageLogEntry message, TelemetryMessageLog messageLog) {
        InetAddress inetAddress;
        FlowMessage flowMessage;
        this.LOG.debug("Received {} telemetry messages", (Object)messageLog.getMessageList().size());
        this.LOG.trace("Parsing packet: {}", (Object)message);
        try {
            flowMessage = FlowMessage.parseFrom((byte[])message.getByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            this.LOG.error("Unable to parse message from proto", (Throwable)e);
            return Stream.empty();
        }
        String address = messageLog.getSourceAddress();
        try {
            inetAddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            this.LOG.warn("Failed to resolve agent address: {}", (Object)address);
            return Stream.empty();
        }
        Optional nodeInfo = this.nodeInfoCache.getNodeInfoFromCache(messageLog.getLocation(), messageLog.getSourceAddress(), this.contextKey, flowMessage.getNodeIdentifier());
        if (!nodeInfo.isPresent()) {
            this.LOG.warn("Unable to find node and interface for agent address: {}", (Object)address);
            return Stream.empty();
        }
        CollectionAgent agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString(((NodeInfo)nodeInfo.get()).getNodeId()), inetAddress);
        ScriptedCollectionSetBuilder builder = this.getCollectionBuilder();
        if (builder == null) {
            this.LOG.error("Error compiling script '{}'. See logs for details.", (Object)this.getScript());
            return Stream.empty();
        }
        Map data = flowMessage.getRawMessageList().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), NetflowTelemetryAdapter.mapToJavaTypes(v)), HashMap::putAll);
        this.rawValuesProcessed.mark((long)flowMessage.getRawMessageList().size());
        try {
            CollectionSet builderResults;
            try (Timer.Context ctx = this.scriptEvaluationTimer.time();){
                builderResults = builder.build(agent, (Object)data, Long.valueOf(message.getTimestamp()));
            }
            this.metricsCollected.mark(((CollectionSetDTO)builderResults).countMetrics());
            return Stream.of(new CollectionSetWithAgent(agent, builderResults));
        }
        catch (ScriptException e) {
            this.LOG.error("Error while running script: {}", (Object)e.getMessage());
            return Stream.empty();
        }
    }

    static Object mapToJavaTypes(Value value) {
        switch (value.getOneofValueCase()) {
            case BOOLEAN: {
                return value.getBoolean().getBool().getValue();
            }
            case FLOAT: {
                return value.getFloat().getDouble().getValue();
            }
            case DATETIME: {
                return value.getDatetime().getUint64().getValue();
            }
            case IPV4ADDRESS: {
                return value.getIpv4Address().getString().getValue();
            }
            case IPV6ADDRESS: {
                return value.getIpv6Address().getString().getValue();
            }
            case MACADDRESS: {
                return value.getMacaddress().getString().getValue();
            }
            case LIST: {
                return value.getList().getListList().stream().map(List::getValueList).map(list -> list.stream().map(NetflowTelemetryAdapter::mapToJavaTypes).collect(Collectors.toList()));
            }
            case SIGNED: {
                return value.getSigned().getInt64().getValue();
            }
            case UNSIGNED: {
                return value.getUnsigned().getUint64().getValue();
            }
            case STRING: {
                return value.getString().getString().getValue();
            }
            case OCTETARRAY: {
                return value.getOctetarray().getBytes().getValue().toByteArray();
            }
            case UNDECLARED: {
                return value.getOctetarray().getBytes().getValue().toByteArray();
            }
        }
        return null;
    }

    public void setCollectionAgentFactory(CollectionAgentFactory collectionAgentFactory) {
        this.collectionAgentFactory = collectionAgentFactory;
    }

    public void setInterfaceToNodeCache(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = interfaceToNodeCache;
    }

    public ContextKey getContextKey() {
        return this.contextKey;
    }

    public String getMetaDataNodeLookup() {
        return this.metaDataNodeLookup;
    }

    public void setMetaDataNodeLookup(String metaDataNodeLookup) {
        this.metaDataNodeLookup = metaDataNodeLookup;
        this.contextKey = !Strings.isNullOrEmpty((String)this.metaDataNodeLookup) ? new ContextKey(metaDataNodeLookup) : null;
    }
}

