/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.CancelLeadershipException;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.state.ConnectionState;
import org.opennms.features.distributed.coordination.common.ConnectionBasedDomainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperDomainManager
extends ConnectionBasedDomainManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperDomainManager.class);
    private LeaderSelector leaderSelector;
    private final CuratorFrameworkFactory.Builder clientBuilder;
    private CuratorFramework client;
    private final LeaderSelectorListener leaderSelectorListener = new LeaderSelectorListenerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void takeLeadership(CuratorFramework client) {
            LOG.trace("calling becomeActive()");
            ZookeeperDomainManager.this.becomeActive();
            1 var2_2 = this;
            synchronized (var2_2) {
                try {
                    while (true) {
                        ((Object)((Object)this)).wait();
                    }
                }
                catch (InterruptedException e) {
                    LOG.debug("Leadership thread was interrupted");
                }
            }
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.LOST || newState == ConnectionState.SUSPENDED) {
                LOG.trace("calling becomeStandby()");
                ZookeeperDomainManager.this.becomeStandby();
            }
            if (client == null) {
                throw new CancelLeadershipException();
            }
            super.stateChanged(client, newState);
        }
    };

    private ZookeeperDomainManager(String domain, CuratorFrameworkFactory.Builder clientBuilder) {
        super(domain);
        this.clientBuilder = clientBuilder;
    }

    private ZookeeperDomainManager(String domain, CuratorFrameworkFactory.Builder mockClientBuilder, LeaderSelector mockLeaderSelector) {
        super(domain);
        this.clientBuilder = mockClientBuilder;
        this.leaderSelector = mockLeaderSelector;
    }

    static ZookeeperDomainManager of(String domain, CuratorFrameworkFactory.Builder clientBuilder) {
        return new ZookeeperDomainManager(domain, clientBuilder);
    }

    static ZookeeperDomainManager withMocks(String domain, CuratorFrameworkFactory.Builder mockClientBuilder, LeaderSelector mockLeaderSelector) {
        return new ZookeeperDomainManager(domain, mockClientBuilder, mockLeaderSelector);
    }

    private void closeConnection() {
        if (this.leaderSelector != null) {
            this.leaderSelector.close();
            this.leaderSelector = null;
        }
        this.client.close();
        this.client = null;
    }

    LeaderSelectorListener getLeaderSelectorListener() {
        return this.leaderSelectorListener;
    }

    protected void failedToConnect(Throwable exception) {
        super.failedToConnect(exception);
        this.closeConnection();
    }

    protected void connect() {
        if (this.isConnected()) {
            return;
        }
        if (this.client == null) {
            this.client = this.clientBuilder.build();
        }
        this.client.start();
        boolean blocked = true;
        while (blocked) {
            try {
                LOG.info("Connecting to ZooKeeper with client {}", (Object)this.client);
                this.client.blockUntilConnected();
                blocked = false;
                LOG.info("Connected to ZooKeeper");
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while connecting to ZooKeeper", (Throwable)e);
            }
        }
        if (this.leaderSelector == null) {
            this.leaderSelector = new LeaderSelector(this.client, "/" + this.getDomain(), this.leaderSelectorListener);
        }
        this.leaderSelector.autoRequeue();
        this.leaderSelector.start();
    }

    protected void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        LOG.info("Disconnecting from ", (Object)this.client);
        this.closeConnection();
    }

    public String toString() {
        return "ZookeeperDomainManager{leaderSelector=" + String.valueOf(this.leaderSelector) + ", leaderSelectorListener=" + String.valueOf(this.leaderSelectorListener) + "} " + super.toString();
    }
}

