/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.core.utils.http.HttpResponseRange;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.web.HttpClientWrapperConfigHelper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.pagesequence.Header;
import org.opennms.netmgt.config.pagesequence.Page;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.pagesequence.Parameter;
import org.opennms.netmgt.config.pagesequence.SessionVariable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.utils.DnsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSequenceMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(PageSequenceMonitor.class);
    private static final int DEFAULT_SEQUENCE_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_RETRY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameterMap) {
        PollStatus serviceStatus = PollStatus.unavailable((String)"Poll not completed yet");
        LinkedHashMap<String, Number> responseTimes = new LinkedHashMap<String, Number>();
        SequenceTracker tracker = new SequenceTracker(parameterMap, 0, 3000);
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            HttpClientWrapper clientWrapper = null;
            try {
                PageSequenceMonitorParameters parms = PageSequenceMonitorParameters.get(parameterMap);
                clientWrapper = parms.createHttpClient();
                responseTimes.put("response-time", Double.NaN);
                tracker.startAttempt();
                parms.getPageSequence().execute(clientWrapper, svc, responseTimes);
                double responseTime = tracker.elapsedTimeInMillis();
                serviceStatus = PollStatus.available();
                responseTimes.put("response-time", responseTime);
            }
            catch (PageSequenceMonitorException e) {
                serviceStatus = PollStatus.unavailable((String)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid parameters to monitor", (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)("Invalid parameter to monitor: " + e.getMessage() + ".  See log for details."));
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception: " + e.getMessage(), e);
                serviceStatus = PollStatus.unavailable((String)("Unexpected exception: " + e.getMessage()));
            }
            finally {
                serviceStatus.setProperties(responseTimes);
                IOUtils.closeQuietly((Closeable)clientWrapper);
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    static {
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }

    protected static class SequenceTracker {
        TimeoutTracker m_tracker;

        public SequenceTracker(Map<String, Object> parameterMap, int defaultSequenceRetry, int defaultTimeout) {
            HashMap<String, Constable> parameters = new HashMap<String, Constable>();
            parameters.put("retry", AbstractServiceMonitor.getKeyedInteger(parameterMap, (String)"sequence-retry", (Integer)defaultSequenceRetry));
            parameters.put("timeout", AbstractServiceMonitor.getKeyedInteger(parameterMap, (String)"timeout", (Integer)defaultTimeout));
            parameters.put("strict-timeout", AbstractServiceMonitor.getKeyedBoolean(parameterMap, (String)"strict-timeout", (Boolean)false));
            this.m_tracker = new TimeoutTracker(parameters, defaultSequenceRetry, defaultTimeout);
        }

        public void reset() {
            this.m_tracker.reset();
        }

        public boolean shouldRetry() {
            return this.m_tracker.shouldRetry();
        }

        public void nextAttempt() {
            this.m_tracker.nextAttempt();
        }

        public void startAttempt() {
            this.m_tracker.startAttempt();
        }

        public double elapsedTimeInMillis() {
            return this.m_tracker.elapsedTimeInMillis();
        }
    }

    public static class PageSequenceMonitorParameters {
        public static final String KEY = PageSequenceMonitorParameters.class.getName();
        private final Map<String, Object> m_parameterMap;
        private final HttpPageSequence m_pageSequence;

        static synchronized PageSequenceMonitorParameters get(Map<String, Object> parameterMap) {
            PageSequenceMonitorParameters parms = (PageSequenceMonitorParameters)parameterMap.get(KEY);
            if (parms == null) {
                parms = new PageSequenceMonitorParameters(parameterMap);
                parameterMap.put(KEY, parms);
            }
            return parms;
        }

        PageSequenceMonitorParameters(Map<String, Object> parameterMap) {
            this.m_parameterMap = parameterMap;
            Object pageSequence = AbstractServiceMonitor.getKeyedObject(parameterMap, (String)"page-sequence", null);
            if (pageSequence == null) {
                throw new IllegalArgumentException("page-sequence must be set in monitor parameters");
            }
            if (pageSequence instanceof PageSequence) {
                pageSequence = JaxbUtils.marshal((Object)pageSequence);
            } else if (!(pageSequence instanceof String)) {
                throw new IllegalArgumentException("Unsure how to deal with Page Sequence of type " + String.valueOf(pageSequence.getClass()));
            }
            pageSequence = PropertiesUtils.substitute((String)((String)pageSequence), (Map[])new Map[]{this.m_parameterMap});
            PageSequence sequence = this.parsePageSequence((String)pageSequence);
            this.m_pageSequence = new HttpPageSequence(sequence);
            this.m_pageSequence.setParameters(this.m_parameterMap);
        }

        Map<String, Object> getParameterMap() {
            return this.m_parameterMap;
        }

        HttpPageSequence getPageSequence() {
            return this.m_pageSequence;
        }

        PageSequence parsePageSequence(String sequenceString) {
            return (PageSequence)JaxbUtils.unmarshal(PageSequence.class, (String)sequenceString);
        }

        public int getRetries() {
            return AbstractServiceMonitor.getKeyedInteger(this.m_parameterMap, (String)"retry", (Integer)0);
        }

        public int getTimeout() {
            return AbstractServiceMonitor.getKeyedInteger(this.m_parameterMap, (String)"timeout", (Integer)3000);
        }

        HttpClientWrapper createHttpClient() {
            HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(this.getTimeout())).setSocketTimeout(Integer.valueOf(this.getTimeout())).setRetries(Integer.valueOf(this.getRetries())).useBrowserCompatibleCookies();
            HttpClientWrapperConfigHelper.setUseSystemProxyIfDefined((HttpClientWrapper)clientWrapper, this.m_parameterMap);
            return clientWrapper;
        }
    }

    public static class HttpPageSequence {
        final PageSequence m_sequence;
        final List<HttpPage> m_pages;
        Properties m_sequenceProperties;
        Map<String, Object> m_parameters = new HashMap<String, Object>();

        HttpPageSequence(PageSequence sequence) {
            this.m_sequence = sequence;
            this.m_pages = new ArrayList<HttpPage>(this.m_sequence.getPages().size());
            for (Page page : this.m_sequence.getPages().toArray(new Page[0])) {
                this.m_pages.add(new HttpPage(this, page));
            }
            this.m_sequenceProperties = new Properties();
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.m_parameters = parameters;
        }

        List<HttpPage> getPages() {
            return this.m_pages;
        }

        private void execute(HttpClientWrapper clientWrapper, MonitoredService svc, Map<String, Number> responseTimes) {
            this.clearSequenceProperties();
            for (HttpPage page : this.getPages()) {
                if (page.getDsName() == null) continue;
                responseTimes.put(page.getDsName(), Double.NaN);
            }
            for (HttpPage page : this.getPages()) {
                LOG.debug("Executing HttpPage: {}", (Object)page.toString());
                page.execute(clientWrapper, svc, this.m_sequenceProperties);
                if (page.getDsName() == null) continue;
                LOG.debug("Recording response time {} for ds {}", (Object)page.getResponseTime(), (Object)page.getDsName());
                responseTimes.put(page.getDsName(), page.getResponseTime());
            }
        }

        protected Properties getSequenceProperties() {
            return this.m_sequenceProperties;
        }

        protected void setSequenceProperties(Properties newProps) {
            this.m_sequenceProperties = newProps;
        }

        protected void clearSequenceProperties() {
            this.m_sequenceProperties.clear();
        }
    }

    public static class PageSequenceMonitorException
    extends RuntimeException {
        private static final long serialVersionUID = 1346757238604080088L;

        public PageSequenceMonitorException(String message) {
            super(message);
        }

        public PageSequenceMonitorException(Throwable cause) {
            super(cause);
        }

        public PageSequenceMonitorException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class HttpPage {
        private final Page m_page;
        private final HttpResponseRange m_range;
        private final Pattern m_successPattern;
        private final Pattern m_failurePattern;
        private final Pattern m_locationPattern;
        private final HttpPageSequence m_parentSequence;
        private double m_responseTime;
        private final List<NameValuePair> m_parms = new ArrayList<NameValuePair>();

        HttpPage(HttpPageSequence parent, Page page) {
            this.m_page = page;
            this.m_range = new HttpResponseRange(page.getResponseRange());
            this.m_successPattern = page.getSuccessMatch() == null ? null : Pattern.compile(page.getSuccessMatch());
            this.m_failurePattern = page.getFailureMatch() == null ? null : Pattern.compile(page.getFailureMatch());
            this.m_locationPattern = page.getLocationMatch() == null ? null : Pattern.compile(page.getLocationMatch());
            this.m_parentSequence = parent;
            for (Parameter parm : this.m_page.getParameters().toArray(new Parameter[0])) {
                this.m_parms.add((NameValuePair)new BasicNameValuePair(parm.getKey(), parm.getValue()));
            }
        }

        public String toString() {
            ToStringBuilder retval = new ToStringBuilder((Object)this);
            retval.append("page.httpVersion", (Object)this.m_page.getHttpVersion());
            retval.append("page.host", (Object)this.m_page.getHost());
            retval.append("page.requireIPv4", (Object)this.m_page.getRequireIPv4());
            retval.append("page.requireIPv6", (Object)this.m_page.getRequireIPv6());
            retval.append("page.port", (Object)this.m_page.getPort());
            retval.append("page.method", (Object)this.m_page.getMethod());
            retval.append("page.virtualHost", (Object)this.m_page.getVirtualHost());
            retval.append("page.path", (Object)this.m_page.getPath());
            retval.append("page.query", (Object)this.m_page.getQuery());
            retval.append("page.successMatch", (Object)this.m_page.getSuccessMatch());
            retval.append("page.failureMatch", (Object)this.m_page.getFailureMatch());
            retval.append("page.locationMatch", (Object)this.m_page.getLocationMatch());
            return retval.toString();
        }

        void execute(HttpClientWrapper parentClientWrapper, MonitoredService svc, Properties sequenceProperties) {
            CloseableHttpResponse response = null;
            try (HttpClientWrapper clientWrapper = parentClientWrapper.duplicate();){
                Matcher matcher;
                String preemptiveAuth;
                URI uri = this.getURI(svc);
                PageSequenceHttpUriRequest method = this.getMethod(uri);
                if (this.getVirtualHost(svc) == null) {
                    LOG.debug("Adding request interceptor to remove the host header");
                    clientWrapper.addRequestInterceptor(new HttpRequestInterceptor(){

                        public void process(HttpRequest request, HttpContext ctx) throws HttpException, IOException {
                            org.apache.http.Header host = request.getFirstHeader("Host");
                            if (host != null) {
                                request.removeHeader(host);
                                LOG.debug("httpRequestInterceptor: virtual-host is not set, removing host header");
                            }
                        }
                    });
                } else {
                    Object host = new HttpHost(this.getVirtualHost(svc), uri.getPort());
                    clientWrapper.setVirtualHost(host.toHostString());
                }
                switch (this.m_page.getHttpVersion()) {
                    case "0.9": {
                        clientWrapper.setVersion(HttpVersion.HTTP_0_9);
                        break;
                    }
                    case "1.0": {
                        clientWrapper.setVersion(HttpVersion.HTTP_1_0);
                        break;
                    }
                    default: {
                        clientWrapper.setVersion(HttpVersion.HTTP_1_1);
                    }
                }
                if (this.getUserAgent() != null && !this.getUserAgent().trim().isEmpty()) {
                    clientWrapper.setUserAgent(this.getUserAgent());
                } else {
                    clientWrapper.setUserAgent("OpenNMS PageSequenceMonitor (Service name: " + svc.getSvcName() + ")");
                }
                if ("https".equals(uri.getScheme()) && Boolean.parseBoolean(this.m_page.getDisableSslVerification())) {
                    try {
                        clientWrapper.useRelaxedSSL("https");
                    }
                    catch (GeneralSecurityException e) {
                        LOG.warn("Failed configure relaxed SSL for PageSequence {}", (Object)svc.getSvcName(), (Object)e);
                    }
                }
                if (this.m_parms.size() > 0) {
                    method.setQueryParameters(this.expandParms(svc));
                }
                for (Header header : this.m_page.getHeaders()) {
                    if (Strings.isNullOrEmpty((String)header.getName())) {
                        LOG.debug("Ignoring header with empty name (value='{}')", (Object)header.getValue());
                        continue;
                    }
                    method.setHeader((org.apache.http.Header)new BasicHeader(header.getName(), header.getValue()));
                    LOG.debug("Using header '{}'", (Object)(header.getName() + ": " + header.getValue()));
                }
                String userInfo = this.getUserInfo();
                if (userInfo != null) {
                    String[] streetCred = userInfo.split(":", 2);
                    if (streetCred.length == 2) {
                        clientWrapper.addBasicCredentials(streetCred[0], streetCred[1]);
                    } else {
                        LOG.warn("Illegal value found for username/password HTTP credentials: {}", (Object)userInfo);
                    }
                }
                if ((preemptiveAuth = this.getPreemptiveAuth()) != null) {
                    switch (preemptiveAuth.toLowerCase()) {
                        case "basic": {
                            clientWrapper.addRequestInterceptor((request, context) -> {
                                if (userInfo == null) {
                                    LOG.warn("preemptiveAuth=\"basic\" but user-info is empty");
                                    return;
                                }
                                org.apache.http.Header[] headers = request.getHeaders("Authorization");
                                if (headers == null || headers.length == 0) {
                                    Base64 base64codec = new Base64(0);
                                    String encodedUserInfo = base64codec.encodeAsString(userInfo.getBytes(StandardCharsets.UTF_8));
                                    request.setHeader("Authorization", "Basic " + encodedUserInfo);
                                }
                            });
                            break;
                        }
                        default: {
                            LOG.warn("Illegal value found for preselect-auth: {}", (Object)preemptiveAuth);
                        }
                    }
                }
                long startTime = System.nanoTime();
                response = clientWrapper.execute((HttpUriRequest)method);
                long endTime = System.nanoTime();
                this.m_responseTime = (double)(endTime - startTime) / 1000000.0;
                int code = response.getStatusLine().getStatusCode();
                if (!this.getRange().contains(code)) {
                    LOG.debug("Response code out of range for URI:" + String.valueOf(uri) + ".  Expected " + String.valueOf(this.getRange()) + " but received " + code);
                    throw new PageSequenceMonitorException("Response code out of range for URI:" + String.valueOf(uri) + ".  Expected " + String.valueOf(this.getRange()) + " but received " + code);
                }
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (this.getLocationPattern() != null) {
                    org.apache.http.Header locationHeader = response.getFirstHeader("location");
                    if (locationHeader == null) {
                        LOG.debug("locationMatch was set, but no Location: header was returned at {}", (Object)uri, (Object)new Exception());
                        throw new PageSequenceMonitorException("locationMatch was set, but no Location: header was returned at " + String.valueOf(uri));
                    }
                    Matcher matcher2 = this.getLocationPattern().matcher(locationHeader.getValue());
                    if (!matcher2.find()) {
                        LOG.debug("Failed to find '{}' in Location: header at {}:\n{}", new Object[]{this.getLocationPattern(), uri, locationHeader.getValue(), new Exception()});
                        throw new PageSequenceMonitorException("Failed to find '" + String.valueOf(this.getLocationPattern()) + "' in Location: header at " + String.valueOf(uri));
                    }
                }
                if (this.getFailurePattern() != null && (matcher = this.getFailurePattern().matcher(responseString)).find()) {
                    throw new PageSequenceMonitorException(this.getResolvedFailureMessage(matcher));
                }
                if (this.getSuccessPattern() != null) {
                    matcher = this.getSuccessPattern().matcher(responseString);
                    if (!matcher.find()) {
                        LOG.debug("Failed to find '{}' in page content at {}:\n{}", new Object[]{this.getSuccessPattern(), uri, responseString.trim(), new Exception()});
                        throw new PageSequenceMonitorException("Failed to find '" + String.valueOf(this.getSuccessPattern()) + "' in page content at " + String.valueOf(uri));
                    }
                    this.updateSequenceProperties(sequenceProperties, matcher);
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to construct URL for page", e);
            }
            catch (ConnectTimeoutException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
                throw new PageSequenceMonitorException(e.getMessage(), e);
            }
            catch (IOException e) {
                Throwable cause = e;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                LOG.debug(cause.getMessage(), cause);
                throw new PageSequenceMonitorException(cause.getMessage(), cause);
            }
        }

        private List<NameValuePair> expandParms(MonitoredService svc) {
            Properties seqProps;
            ArrayList<NameValuePair> expandedParms = new ArrayList<NameValuePair>();
            Properties svcProps = AbstractServiceMonitor.getServiceProperties((MonitoredService)svc);
            if (svcProps != null) {
                LOG.debug("I have {} service properties.", (Object)svcProps.size());
            }
            if ((seqProps = this.getSequenceProperties()) != null) {
                LOG.debug("I have {} sequence properties.", (Object)seqProps.size());
            }
            for (NameValuePair nvp : this.m_parms) {
                String value = PropertiesUtils.substitute((String)nvp.getValue(), (Properties[])new Properties[]{AbstractServiceMonitor.getServiceProperties((MonitoredService)svc), this.getSequenceProperties()});
                expandedParms.add((NameValuePair)new BasicNameValuePair(nvp.getName(), value));
                if (nvp.getValue().equals(value)) continue;
                LOG.debug("Expanded parm with name '{}' from '{}' to '{}'", new Object[]{nvp.getName(), nvp.getValue(), value});
            }
            return expandedParms;
        }

        private void updateSequenceProperties(Properties props, Matcher matcher) {
            for (SessionVariable varBinding : this.m_page.getSessionVariables()) {
                String vbName = varBinding.getName();
                String vbValue = matcher.group(varBinding.getMatchGroup());
                if (vbValue == null) {
                    vbValue = "";
                }
                props.put(vbName, vbValue);
                LOG.debug("Just set session variable '{}' to '{}'", (Object)vbName, (Object)vbValue);
            }
            this.setSequenceProperties(props);
        }

        private String getUserAgent() {
            return this.m_page.getUserAgent();
        }

        private String getVirtualHost(MonitoredService svc) {
            return PropertiesUtils.substitute((String)this.m_page.getVirtualHost(), (Properties[])new Properties[]{AbstractServiceMonitor.getServiceProperties((MonitoredService)svc), this.getSequenceProperties()});
        }

        private URI getURI(MonitoredService svc) throws URISyntaxException {
            InetAddress address;
            Properties svcProps = AbstractServiceMonitor.getServiceProperties((MonitoredService)svc);
            Properties seqProps = this.getSequenceProperties();
            Object host = this.getHost(seqProps, svcProps);
            if (this.m_page.getRequireIPv4().booleanValue()) {
                try {
                    address = DnsUtils.resolveHostname((String)host, false);
                    if (!(address instanceof Inet4Address)) {
                        throw new UnknownHostException();
                    }
                    host = InetAddressUtils.str((InetAddress)address);
                }
                catch (UnknownHostException e) {
                    throw new PageSequenceMonitorException("Failed to find IPv4 address for hostname: " + (String)host);
                }
            }
            if (this.m_page.getRequireIPv6().booleanValue()) {
                try {
                    address = DnsUtils.resolveHostname((String)host, true);
                    host = "[" + InetAddressUtils.str((InetAddress)address) + "]";
                }
                catch (UnknownHostException e) {
                    throw new PageSequenceMonitorException("Failed to find IPv6 address for hostname: " + (String)host);
                }
            }
            URIBuilder ub = new URIBuilder();
            ub.setScheme(this.getScheme());
            ub.setHost((String)host);
            ub.setPort(this.getPort(new Properties[0]));
            ub.setPath(this.getPath(seqProps, svcProps));
            String query = this.getQuery(seqProps, svcProps);
            if (query != null) {
                List params = URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8);
                ub.setParameters(params);
            }
            ub.setFragment(this.getFragment(seqProps, svcProps));
            return ub.build();
        }

        private String getFragment(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getFragment(), (Properties[])p);
        }

        private String getQuery(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getQuery(), (Properties[])p);
        }

        private String getPath(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getPath(), (Properties[])p);
        }

        private int getPort(Properties ... p) {
            return Integer.valueOf(PropertiesUtils.substitute((String)String.valueOf(this.m_page.getPort()), (Properties[])p));
        }

        private String getHost(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getHost(), (Properties[])p);
        }

        private String getUserInfo() {
            return this.m_page.getUserInfo();
        }

        private String getPreemptiveAuth() {
            return this.m_page.getPreemptiveAuth();
        }

        private String getScheme() {
            return this.m_page.getScheme();
        }

        private PageSequenceHttpUriRequest getMethod(URI uri) {
            String method = this.m_page.getMethod();
            return "GET".equalsIgnoreCase(method) ? new PageSequenceHttpGet(uri) : new PageSequenceHttpPost(uri);
        }

        private HttpResponseRange getRange() {
            return this.m_range;
        }

        private Pattern getSuccessPattern() {
            return this.m_successPattern;
        }

        private Pattern getLocationPattern() {
            return this.m_locationPattern;
        }

        private Pattern getFailurePattern() {
            return this.m_failurePattern;
        }

        private String getFailureMessage() {
            return this.m_page.getFailureMessage();
        }

        private String getResolvedFailureMessage(Matcher matcher) {
            return PropertiesUtils.substitute((String)this.getFailureMessage(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{new MatchTable(matcher)});
        }

        private Properties getSequenceProperties() {
            return this.m_parentSequence.getSequenceProperties();
        }

        private void setSequenceProperties(Properties props) {
            this.m_parentSequence.setSequenceProperties(props);
        }

        public Number getResponseTime() {
            return this.m_responseTime;
        }

        public String getDsName() {
            return this.m_page.getDsName();
        }
    }

    public static class PageSequenceHttpGet
    extends HttpGet
    implements PageSequenceHttpUriRequest {
        public PageSequenceHttpGet(URI uri) {
            super(uri);
        }

        @Override
        public void setQueryParameters(List<NameValuePair> parms) {
            URI uri = this.getURI();
            URI uriWithQueryString = null;
            try {
                String query = URLEncodedUtils.format(parms, (Charset)StandardCharsets.UTF_8);
                URIBuilder ub = new URIBuilder(uri);
                List params = URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8);
                if (!params.isEmpty()) {
                    ub.setParameters(params);
                }
                uriWithQueryString = ub.build();
                this.setURI(uriWithQueryString);
            }
            catch (URISyntaxException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class PageSequenceHttpPost
    extends HttpPost
    implements PageSequenceHttpUriRequest {
        public PageSequenceHttpPost(URI uri) {
            super(uri);
        }

        @Override
        public void setQueryParameters(List<NameValuePair> parms) {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parms, StandardCharsets.UTF_8);
            this.setEntity((HttpEntity)entity);
        }
    }

    public static interface PageSequenceHttpUriRequest
    extends HttpUriRequest {
        public void setQueryParameters(List<NameValuePair> var1);
    }
}

