/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.grpc.common;

import com.google.common.base.Strings;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.SSLException;
import org.opennms.core.grpc.common.GrpcClientBuilder;
import org.opennms.core.utils.PropertiesUtils;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcIpcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcClientBuilder.class);
    public static final String GRPC_CLIENT_PID = "org.opennms.core.ipc.grpc.client";
    public static final String GRPC_SERVER_PID = "org.opennms.core.ipc.grpc.server";
    public static final String LOG_PREFIX = "ipc";
    public static final String GRPC_HOST = "host";
    public static final String DEFAULT_GRPC_HOST = "localhost";
    public static final String GRPC_PORT = "port";
    public static final int DEFAULT_TWIN_GRPC_PORT = 8991;
    public static final String TLS_ENABLED = "tls.enabled";
    public static final String GRPC_MAX_INBOUND_SIZE = "max.message.size";
    public static final int DEFAULT_MESSAGE_SIZE = 0xA00000;
    public static final String CLIENT_CERTIFICATE_FILE_PATH = "client.cert.filepath";
    public static final String CLIENT_PRIVATE_KEY_FILE_PATH = "client.private.key.filepath";
    public static final String TRUST_CERTIFICATE_FILE_PATH = "trust.cert.filepath";
    public static final String SERVER_CERTIFICATE_FILE_PATH = "server.cert.filepath";
    public static final String PRIVATE_KEY_FILE_PATH = "server.private.key.filepath";

    public static SslContextBuilder buildSslContext(Properties properties) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        String clientCertChainFilePath = properties.getProperty(CLIENT_CERTIFICATE_FILE_PATH);
        String clientPrivateKeyFilePath = properties.getProperty(CLIENT_PRIVATE_KEY_FILE_PATH);
        String trustCertCollectionFilePath = properties.getProperty(TRUST_CERTIFICATE_FILE_PATH);
        if (!Strings.isNullOrEmpty((String)trustCertCollectionFilePath)) {
            builder.trustManager(new File(trustCertCollectionFilePath));
        }
        if (!Strings.isNullOrEmpty((String)clientCertChainFilePath) && !Strings.isNullOrEmpty((String)clientPrivateKeyFilePath)) {
            builder.keyManager(new File(clientCertChainFilePath), new File(clientPrivateKeyFilePath));
        } else if (!Strings.isNullOrEmpty((String)clientCertChainFilePath) || !Strings.isNullOrEmpty((String)clientPrivateKeyFilePath)) {
            LOG.error("Only one of the required file paths were provided, need both client cert and client private key");
        }
        return builder;
    }

    public static ManagedChannel getChannel(Properties properties, int port) throws IOException {
        String host = PropertiesUtils.getProperty((Properties)properties, (String)GRPC_HOST, (String)DEFAULT_GRPC_HOST);
        int maxInboundMessageSize = PropertiesUtils.getProperty((Properties)properties, (String)GRPC_MAX_INBOUND_SIZE, (int)0xA00000);
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(maxInboundMessageSize).keepAliveWithoutCalls(true);
        boolean tlsEnabled = Boolean.parseBoolean(properties.getProperty(TLS_ENABLED));
        if (tlsEnabled) {
            return channelBuilder.negotiationType(NegotiationType.TLS).sslContext(GrpcIpcUtils.buildSslContext(properties).build()).build();
        }
        return channelBuilder.usePlaintext().build();
    }

    public static SslContextBuilder getSslContextBuilder(Properties properties) {
        String certChainFilePath = properties.getProperty(SERVER_CERTIFICATE_FILE_PATH);
        String privateKeyFilePath = properties.getProperty(PRIVATE_KEY_FILE_PATH);
        String trustCertCollectionFilePath = properties.getProperty(TRUST_CERTIFICATE_FILE_PATH);
        if (Strings.isNullOrEmpty((String)certChainFilePath) || Strings.isNullOrEmpty((String)privateKeyFilePath)) {
            return null;
        }
        SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((File)new File(certChainFilePath), (File)new File(privateKeyFilePath));
        if (!Strings.isNullOrEmpty((String)trustCertCollectionFilePath)) {
            sslClientContextBuilder.trustManager(new File(trustCertCollectionFilePath));
            sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
        }
        return GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)SslProvider.OPENSSL);
    }

    public static Properties getPropertiesFromConfig(ConfigurationAdmin configAdmin, String pid) {
        Properties properties = new Properties();
        try {
            Dictionary config = configAdmin.getConfiguration(pid).getProperties();
            if (config != null) {
                Enumeration keys = config.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    properties.put(key, config.get(key));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load config", e);
        }
        return properties;
    }
}

