/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.swrve.ratelimitedlogger.CounterMetric;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import com.swrve.ratelimitedlogger.RateLimitedLogWithPattern;
import com.swrve.ratelimitedlogger.Stopwatch;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public class RateLimitedLogBuilder {
    private final Logger logger;
    private final int maxRate;
    private final Duration periodLength;
    private Stopwatch stopwatch = new Stopwatch();
    @Nullable
    private CounterMetric stats = null;

    private RateLimitedLogBuilder(Logger logger, int maxRate, Duration periodLength) {
        this.logger = logger;
        this.maxRate = maxRate;
        this.periodLength = periodLength;
    }

    public RateLimitedLogBuilder withStopwatch(Stopwatch stopwatch) {
        this.stopwatch = Objects.requireNonNull(stopwatch);
        return this;
    }

    public RateLimitedLogBuilder recordMetrics(CounterMetric stats) {
        this.stats = Objects.requireNonNull(stats);
        return this;
    }

    public RateLimitedLog build() {
        if (this.maxRate <= 0) {
            throw new IllegalArgumentException("maxRate must be > 0");
        }
        if (this.periodLength.toMillis() <= 0L) {
            throw new IllegalArgumentException("period must be non-zero");
        }
        this.stopwatch.start();
        return new RateLimitedLog(this.logger, new RateLimitedLogWithPattern.RateAndPeriod(this.maxRate, this.periodLength), this.stopwatch, this.stats, RateLimitedLog.REGISTRY);
    }

    public static class MissingPeriod {
        private final Logger logger;
        private final int maxRate;

        private MissingPeriod(Logger logger, int rate) {
            Objects.requireNonNull(logger);
            this.logger = logger;
            this.maxRate = rate;
        }

        public RateLimitedLogBuilder every(Duration duration) {
            Objects.requireNonNull(duration);
            return new RateLimitedLogBuilder(this.logger, this.maxRate, duration);
        }
    }

    public static class MissingRateAndPeriod {
        private final Logger logger;

        MissingRateAndPeriod(Logger logger) {
            this.logger = logger;
        }

        public MissingPeriod maxRate(int rate) {
            return new MissingPeriod(this.logger, rate);
        }
    }
}

