/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.telemetry.config.api.ConnectorDefinition;
import org.opennms.netmgt.telemetry.config.model.PackageConfig;
import org.opennms.netmgt.telemetry.config.model.Parameter;
import org.opennms.netmgt.telemetry.config.model.QueueConfig;

@XmlRootElement(name="connector")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ConnectorConfig
implements ConnectorDefinition {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="class-name", required=true)
    private String className;
    @XmlAttribute(name="service-name", required=true)
    private String serviceName;
    @XmlAttribute(name="queue", required=true)
    @XmlIDREF
    private QueueConfig queue;
    @XmlAttribute(name="enabled")
    private boolean enabled;
    @XmlElement(name="parameter")
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @XmlElement(name="package")
    private List<PackageConfig> packages = new ArrayList<PackageConfig>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public QueueConfig getQueue() {
        return this.queue;
    }

    public void setQueue(QueueConfig queue) {
        this.queue = queue;
    }

    @XmlTransient
    public String getQueueName() {
        if (this.queue != null) {
            return this.queue.getName();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParameterMap() {
        return this.parameters.stream().collect(Collectors.toMap(Parameter::getKey, Parameter::getValue));
    }

    public List<PackageConfig> getPackages() {
        return this.packages;
    }

    public void setPackages(List<PackageConfig> packages) {
        this.packages = packages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorConfig that = (ConnectorConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.queue, that.queue) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.packages, that.packages);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.serviceName, this.queue, this.enabled, this.parameters, this.packages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("class-name", (Object)this.className).add("service-name", (Object)this.serviceName).add("queue", (Object)this.queue).add("enabled", this.enabled).addValue(this.parameters).add("packages", this.packages).toString();
    }
}

